<?php

App::uses('AppComponent', 'Controller/Component');

class OptionsComponent extends AppComponent {

/**
 * Run the form injection
 * For custom fields this add type / validation arrays to the template for fields
 *
 * @param array    $data  Data from $this->request->data.
 * @param Model    $Model Model object for the primary model we are dealing with.
 * @param int|null $id    The ID if on edit or null if being added.
 * @return void.
 */
	public function injectAdminForm($data, $Model, $id) {
		if (empty($this->_controller->Option)) {
			$this->_controller->loadModel('EvShop.Option');
		}

		$Option = $this->_controller->Option;

		if (empty($this->_controller->request->data[$Option->alias])) {
			return;
		}

		foreach ($this->_controller->request->data[$Option->alias] as &$option) {
			if (empty($option[$Option->primaryKey])) {
				continue;
			}

			$option['is_used'] = $Option->isUsed($option[$Option->primaryKey]);
		}

		$this->_controller->helpers[] = 'EvShop.Options';
	}
}
