<?php
App::uses('EvShopAppController', 'EvShop.Controller');

class BrandsController extends EvShopAppController {

	/**
	 * redefine to allow the index / view page through the auth component!
	 */
	public function beforeFilter() {
		if (! Configure::read('EvShop.showBrands')) {
			throw new NotFoundException();
		}

		parent::beforeFilter();

		$this->Auth->allow(array('index', 'view'));
	}

	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();

		$Model = $this->{$this->modelClass};

		// assigns list of parent brands
		if (Configure::read('EvShop.brandsHaveParents') == true) {
			$parentsParams = [
				'conditions' => [
					$Model->alias . '.parent_id' => ''
				],
				'order' => [
					$Model->alias . '.name' => 'ASC'
				]
			];

			// if a brand id is set then omit from the list
			if (! empty($this->request->data[$Model->alias]['id'])) {
				$parentsParams['conditions'][$Model->alias . '.id !='] = $this->request->data[$Model->alias]['id'];
			}

			$this->set('parents', $Model->find('list', $parentsParams));
		}
	}

/**
 * Defines the fields displayed in a filter form.
 *
 * @return Array containing filter fields to use on the page
 */
	protected function _adminFilterFields() {
		$filterFields = parent::_adminFilterFields();

		$Model = $this->{$this->modelClass};

		// assigns parent brand filter field, when functionality is required
		if (Configure::read('EvShop.brandsHaveParents') == true) {
			$additionalFilterFields = [
				$Model->alias . '.parent_id' => [
					'compare' => [
						$Model->alias . '.parent_id' => '%s'
					],
					'label' => 'Parent',
					'type' => 'select'
				]
			];

			$filterFields = ArrayUtil::addAfter(
				$filterFields,
				$Model->alias . '.name',
				$additionalFilterFields
			);
		}

		unset(
			$filterFields[$Model->alias . '.created'],
			$filterFields[$Model->alias . '.modified']
		);

		return $filterFields;
	}

/**
 * Defines the columns displayed in the admin_index results table
 * using a columns whitelist.
 *
 * @return Array of columns to display on the template
 */
	protected function _adminIndexColumns() {
		$indexColumns = parent::_adminIndexColumns();

		$Model = $this->{$this->modelClass};

		// assigns parent brand column, when functionality is required
		if (Configure::read('EvShop.brandsHaveParents') == true) {
			$additionalIndexColumns = [
				'ParentBrand.name' => [
					'default' => '-',
					'label' => 'Parent',
					'type' => 'string'
				]
			];

			$indexColumns = ArrayUtil::addAfter(
				$indexColumns,
				$Model->alias . '.name',
				$additionalIndexColumns
			);
		}

		return $indexColumns;
	}

/**
 * Pagination settings for admin_index
 *
 * @return array
 */
	protected function _adminIndexPaginate() {
		$indexPaginate = parent::_adminIndexPaginate();

		$indexPaginate['contain'][] = 'ParentBrand';

		return $indexPaginate;
	}

/**
 * Assigns an arry of form fields to show on the admin form template
 *
 * @return array Contains the fields to show on the admin form template
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$Model = $this->{$this->modelClass};

		$fields['Brand.body']['type'] = 'html';

		// show the parent select when the brands hierarchy is enabled
		if (Configure::read('EvShop.brandsHaveParents') != true) {
			unset($fields[$Model->alias . '.parent_id']);
		}

		return $fields;
	}

	/**
	 * process the param array for brands
	 *
	 * @return 	array 		   	  Standard parameter array to pass to find
	 */
	protected function _processBrandParams() {
		return array();
	}

	/**
	 * process the param array for products
	 *
	 * @param 	array 	$Brand The parent Brand
	 * @return 	array 		   	  Standard parameter array to pass to find
	 */
	protected function _processProductParams($Brand) {
		return array();
	}

	/**
	 * brands index page
	 * list all brands out
	 *
	 */
	public function index() {
		$this->view = 'EvShop./Fallbacks/Brands/index';
		$pageId = Configure::read('EvShop.pageIds.brand');

		// check if we have a specific content page set
		// if so - set the template
		if (! empty($pageId)) {
			$pageData = $this->assignPage($pageId);

			if (! empty($pageData)) {
				$this->view = $this->Tpl->getTemplate($pageData, 'Page');
			}
		}

		$this->set(
			'listing',
			$this->Brands->listing(
				$this->_processBrandParams()
			)
		);

		$this->Breadcrumb->addCrumb(__('Brands'));
	}

	/**
	 * brand view details page
	 *
	 * @param 	int 	Brand ID
	 */
	public function view($id) {
		$this->view = 'EvShop./Fallbacks/Brands/view';
		$Model = $this->{$this->modelClass};

		$data = $Model->readForView($id);
		if (empty($data)) {
			throw new NotFoundException();
		}

		$this->set('data', $data);
		$this->Meta->set($data);

		if (! empty($data[$Model->alias]['template_id'])) {
			$this->view = $this->Tpl->getTemplate($data);
		}

		$this->set(
			'productListing',
			$this->Products->listingByBrand(
				$id,
				$this->_processProductParams($data)
			)
		);

		$this->Breadcrumb->addCrumb(
			__('Brands'),
			$this->Routable->getListingRoute('EvShop', 'Brand')
		);

		$this->Breadcrumb->addCrumb(
			$data['Brand']['name']
		);
	}

}
