<?php

App::uses('UpdateMetaShell', 'MetaData.Console/Command');

class UpdateProductMetaShell extends UpdateMetaShell {

/**
 * Gets the option parser instance and configures it.
 *
 * @return ConsoleOptionParser
 * @link http://book.cakephp.org/2.0/en/console-and-shells.html#Shell::getOptionParser
 */
	public function getOptionParser() {
		$parser = parent::getOptionParser();

		$parser->addSubcommand(
			'replacePriceWithToken',
			[
				'help' => 'Replace text in the meta data description with a meta data token',
				'parser' => $this->_getReplacePriceWithTokenParser(),
			]
		);

		return $parser;
	}

/**
 * Gets the option parser instance for the `replaceDescriptionPriceWithToken` subCommand and configures it.
 *
 * @return ConsoleOptionParser
 * @link http://book.cakephp.org/2.0/en/console-and-shells.html#Shell::getOptionParser
 */
	protected function _getReplacePriceWithTokenParser() {
		return parent::getOptionParser();
	}

/**
 * Replace all the prices in product meta descriptions with the Product.price meta token.
 *
 * @return void.
 */
	public function replacePriceWithToken() {
		$priceRegex = '£[0-9,]+(?:\.[0-9]{2})?';

		$this->dispatchShell('MetaData.UpdateMeta replaceTitleWithToken EvShop.Product ' . $priceRegex . ' {Product.price}');
		$this->dispatchShell('MetaData.UpdateMeta replaceDescriptionWithToken EvShop.Product ' . $priceRegex . ' {Product.price}');

		return true;
	}
}
