<?php

App::uses('AppShell', 'Console/Command');

class TidyShopShell extends AppShell {

/**
 * Tidy up variants that should be associated with options but aren't.
 *
 * @return void.
 */
	public function variantsWithMissingOptions() {
		$this->out('Tidying variants with missing options');

		//Find all products with multiple variants, and has variants with no options
		$Product = EvClassRegistry::init('EvShop.Product');

		$batch = 0;
		$batchSize = 100;

		$productParams = [
			'fields' => [
				$Product->alias . '.' . $Product->primaryKey,
			],
			'order' => $Product->alias . '.' . $Product->primaryKey . ' ASC',
			'limit' => $batchSize,
		];

		$products = $Product->find('all', $productParams);

		while (!empty($products)) {
			foreach ($products as $product) {
				$variantCount = $Product->Variant->find(
					'count',
					[
						'conditions' => [
							$Product->Variant->alias . '.product_id' => $product[$Product->alias][$Product->primaryKey],
						],
					]
				);

				if ($variantCount <= 1) {
					continue;
				}

				$variantsMissingOptions = $Product->Variant->find(
					'all',
					[
						'fields' => [
							$Product->Variant->alias . '.' . $Product->Variant->primaryKey,
						],
						'joins' => [
							[
								'type' => 'left',
								'table' => 'ev_shop_options_variants',
								'alias' => 'OptionsVariant',
								'conditions' => [
									'OptionsVariant.variant_id = ' . $Product->Variant->alias . '.' . $Product->Variant->primaryKey,
								],
							],
						],
						'conditions' => [
							$Product->Variant->alias . '.product_id' => $product[$Product->alias][$Product->primaryKey],
						],
						'group' => [
							$Product->Variant->alias . '.' . $Product->Variant->primaryKey,
						],
						'having' => [
							'COUNT(OptionsVariant.id) = 0',
						],
					]
				);

				if (empty($variantsMissingOptions)) {
					continue;
				}

				$this->out('Deleting ' . count($variantsMissingOptions) . ' variants from Product with id: ' . $product[$Product->alias][$Product->primaryKey]);

				$Product->Variant->deleteAll(
					[
						$Product->Variant->alias . '.' . $Product->Variant->primaryKey => Hash::extract(
							$variantsMissingOptions,
							'{n}.' . $Product->Variant->alias . '.' . $Product->Variant->primaryKey
						)
					]
				);
			}

			$batch++;
			$productParams['offset'] = $batch * $batchSize;
			$products = $Product->find('all', $productParams);
		}

		$this->out('Finished tidying variants with missing options');
	}
}
