<?php

App::uses('QueueTask', 'Queue.Console/Command/Task');

class QueueUpdatePricingTask extends QueueTask {

/**
 * "Add" the task
 *
 * @return void
 */
	public function add() {
		// Add Rebuild job to the queue
		$QueuedTask = EvClassRegistry::init('Queue.QueuedTask');

		$QueuedTask->createJob(
			'UpdatePricing'
		);

		// Clear any duplicates so it doesn't run rebuild twice
		$QueuedTask->clearDoublettes();
	}

/**
 * @param mixed $data Job data
 * @param int $id The id of the QueuedTask
 * @return bool Success
 */
	public function run($data, $id = null) {
		$Currency = EvClassRegistry::init('EvCurrency.Currency');
		$defaultCurrency = $Currency->find('first', array(
			'conditions' => array(
				'is_default' => 1
			)
		));

		if (empty($defaultCurrency)) {
			$this->out('No default currency set');
			return false;
		}

		$VariantPricing = EvClassRegistry::init('EvShop.VariantPricing');
		$VariantPricing->validator()->remove('rrp');
		$pricingData = $VariantPricing->find('all', array(
			'conditions' => array(
				'currency_id' => $defaultCurrency['Currency']['id']
			)
		));
		$pricingRecords = array();

		if (! empty($pricingData)) {
			foreach ($pricingData as $price) {
				if (!empty($price['VariantPricing']['variant_id'])) {
					$pricingRecords[] = $VariantPricing->updateLowestPrice($price);
				}
			}
		}

		$VariantPricing->clear();

		$result = true;
		if (!empty($pricingRecords)) {
			$result = $VariantPricing->saveMany($pricingRecords, array('deep' => false));
		}

		if ($result) {
			$this->out('lowest_price field has been updated for all variants.');
			return true;
		} else {
			$this->out('<error>Failed to update lowest_price field.</error>');
			return false;
		}
	}

}
