<?php

App::uses('AppShell', 'Console/Command');

class OverridesShell extends AppShell {

	public $uses = [
		'EvShop.CategoryOverride',
	];

/**
 * Regenerate the hashes for every category override. To be used if new/custom data is added to category override
 * hashes once some have already been generated or if the logic behind hash generation changes.
 *
 * @return void.
 */
	public function regenerateHashes() {
		$regeneration = $this->CategoryOverride->regenerateHashes();

		$this->out('Regenerated ' . $regeneration['overrides'] . ' category overrides');
		$this->out($regeneration['regenerated'] . ' successfully regenerated');
		$this->out($regeneration['failed'] . ' failed regeneration');
	}
}
