<?php

App::uses('AppShell', 'Console/Command');

class GenerateProductFeedXMLShell extends AppShell {

/**
 * Generate the google shopping feed.
 *
 * @return void.
 */
	public function generate() {
		ini_set('memory_limit', '256M');

		$xmlPath = 'webroot/product_feed.xml';
		if (!empty(Configure::read('EvShop.googleFeed.filepath'))) {
			$xmlPath = Configure::read('EvShop.googleFeed.filepath');
		}

		$this->out('Generating Product Feed...');

		$output = $this->_generateFeed();

		$result = file_put_contents(APP . $xmlPath, $output);

		if ($result !== false) {
			$this->out('Success :) File located @ ' . $xmlPath);
		} else {
			$this->out('Failed to save feed at ' . $xmlPath);
		}
	}

/**
 * Generate the google shopping feed.
 *
 * @return xml The generate feed.
 */
	protected function _generateFeed() {
		$feedLib = null;

		// Check for extended lib
		App::uses('EvShopGoogleFeedLib', 'Lib');
		if (class_exists('EvShopGoogleFeedLib')) {
			$feedLib = new EvShopGoogleFeedLib();
		}

		// Fallback on plugin Lib
		if (empty($feedLib)) {
			App::uses('GoogleFeedLib', 'EvShop.Lib');
			$feedLib = new GoogleFeedLib();
		}

		return $feedLib->generate();
	}
}
