<?php

App::uses('PluginInstallShell', 'shells');
App::uses('File', 'Utility');

class EvShopInstallShell extends PluginInstallShell {

	public $uses = array(
		'EvTemplates.Template',
		'EvCore.Page',
		'EvNavigation.Menu',
		'EvSiteSettings.SiteSettingCategory',
		'EvSiteSettings.SiteSetting'
	);

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run() {
		parent::run();

		$date = date('Y-m-d H:i:s');

		// add all the base templates
		$this->Template->saveMany(
			array(
				array(
					'Template' => array(
						'name' => 'Brands Index',
						'template' => 'EvShop./Templates/Brands/index',
						'helperFunction' => 'N/A',
						'cfDataLabel' => 'Custom Data',
						'model' => 'Brand',
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'Template' => array(
						'name' => 'Categories Index',
						'template' => 'EvShop./Templates/Categories/index',
						'helperFunction' => 'N/A',
						'cfDataLabel' => 'Custom Data',
						'model' => 'Category',
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'Template' => array(
						'name' => 'Products Index',
						'template' => 'EvShop./Templates/Products/index',
						'helperFunction' => 'N/A',
						'cfDataLabel' => 'Custom Data',
						'model' => 'Product',
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'Template' => array(
						'name' => 'Brands View',
						'template' => 'EvShop./Templates/Brands/view',
						'helperFunction' => 'N/A',
						'cfDataLabel' => 'Custom Data',
						'model' => 'Brand',
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'Template' => array(
						'name' => 'Categories View',
						'template' => 'EvShop./Templates/Categories/view',
						'helperFunction' => 'N/A',
						'cfDataLabel' => 'Custom Data',
						'model' => 'Category',
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'Template' => array(
						'name' => 'Products View',
						'template' => 'EvShop./Templates/Products/view',
						'helperFunction' => 'N/A',
						'cfDataLabel' => 'Custom Data',
						'model' => 'Product',
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				)
			)
		);
		$templateIds = $this->Template->find('list', array('callbacks' => false, 'limit' => 6, 'order' => 'Template.id DESC'));
		$templateIds = array_flip($templateIds);

		// add the pages for the index
		$this->Page->saveMany(
			array(
				array(
					'Page' => array(
						'title' => 'All Brands',
						'internal_title' => 'all_brands',
						'is_active' => 1,
						'is_protected' => 1,
						'template_id' => $templateIds['Brands Index'],
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'Page' => array(
						'title' => 'All Categories',
						'internal_title' => 'all_categories',
						'is_active' => 1,
						'is_protected' => 1,
						'template_id' => $templateIds['Categories Index'],
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'Page' => array(
						'title' => 'All Products',
						'internal_title' => 'all_products',
						'is_active' => 1,
						'is_protected' => 1,
						'template_id' => $templateIds['Products Index'],
						'created' => $date,
						'modified' => $date
					)
				)
			)
		);
		$pageIds = $this->Page->find('list', array('callbacks' => false, 'limit' => 3, 'order' => 'Page.id DESC'));
		$pageIds = array_flip($pageIds);

		// write to the plugin config
		$configContents = '<?php

$config = array(
	\'EvShop\' => array(
		\'pageIds\' => array( // Page ids for brand, category, product index pages
			\'brand\' => ' . $pageIds['All Brands'] . ',
			\'category\' => ' . $pageIds['All Categories'] . ',
			\'product\' => ' . $pageIds['All Products'] . '
		)
	)
);';

		$File = new File(APP . 'Config/Plugin/ev_shop.php', true);
		$File->write($configContents);

		// Add to the admin menu
		$this->Menu->save(
			array(
				'Menu' => array(
					'parent_id' => 1,
					'name' => 'Catalog',
					'pattern' => '/^\/admin\/ev_shop\//',
					'plugin' => 'EvShop',
					'controller' => 'ev_shop.products',
					'model' => 'Product',
					'action' => 'index',
					'class' => 'icon-shopping-cart',
					'is_active' => 1
				)
			)
		);
		$parentId = $this->Menu->getInsertID();

		$this->Menu->saveMany(
			array(
				array(
					'Menu' => array(
						'parent_id' => $parentId,
						'name' => 'Brands',
						'pattern' => '/^\/admin\/ev_shop\/brands\//',
						'plugin' => 'EvShop',
						'controller' => 'ev_shop.brands',
						'model' => 'Brand',
						'action' => 'index',
						'is_active' => 1
					)
				),
				array(
					'Menu' => array(
						'parent_id' => $parentId,
						'name' => 'Categories',
						'pattern' => '/^\/admin\/ev_shop\/categories\//',
						'plugin' => 'EvShop',
						'controller' => 'ev_shop.categories',
						'model' => 'Category',
						'action' => 'index',
						'is_active' => 1
					)
				),
				array(
					'Menu' => array(
						'parent_id' => $parentId,
						'name' => 'Options',
						'pattern' => '/^\/admin\/ev_shop\/option_groups\//',
						'plugin' => 'EvShop',
						'controller' => 'ev_shop.option_groups',
						'model' => 'OptionGroup',
						'action' => 'index',
						'is_active' => 1
					)
				)
			)
		);

		// Add the site settings category
		$this->SiteSettingCategory->save(
			array(
				'SiteSettingCategory' => array(
					'name' => 'Shop',
					'array_slug' => 'ev_shop',
					'sequence' => 15,
					'prevent_edit' => 0
				)
			)
		);
		$categoryId = $this->SiteSettingCategory->getInsertID();

		// Add the site settings
		$this->SiteSetting->saveMany(
			array(
				array(
					'SiteSetting' => array(
						'name' => 'Enable trade pricing for trade customers?',
						'array_slug' => 'enable_trade_pricing',
						'type' => 'boolean',
						'value' => 1,
						'sequence' => 10,
						'site_setting_category_id' => $categoryId,
						'prevent_edit' => 0
					)
				),
				array(
					'SiteSetting' => array(
						'name' => 'Disable taxing trade prices?',
						'array_slug' => 'disable_tax_on_trade_pricing',
						'type' => 'boolean',
						'value' => 0,
						'sequence' => 20,
						'site_setting_category_id' => $categoryId,
						'prevent_edit' => 0
					)
				)
			)
		);
	}
}
