<?php

$config = array(
	'EvShop' => array(
		'showVariants' => true, // show variant/options to the admin during product management
		'showBrands' => true, // show brands in the admin during product management
		'showAttributes' => false, // show attributes in the admin during product management
		'filterOnAttributes' => false, // use attributes in product filters

		'pageIds' => array( // Page ids for brand, category, product index pages
			'brand' => null,
			'category' => null,
			'product' => null
		),

		'default_oos_actions' => array(),
		'stock' => null,

		/**
		 * Auto Manage Currencies
		 *
		 * When this is enabled, only the 'is_default' currency will be editable via the admin area.
		 * The other currencies will automatically be populated based on their exchange rate. Use
		 * this in combination with the daily currency rate updater system to keep the foreign
		 * prices up to date.
		 */
		'autoManageCurrencies' => true,

		/**
		 * Enables the option to batch manage stock from the CMS.
		 */
		'batchManageStock' => false,

		/*
		 * Set the google shopping feed config
		 */
		'googleFeed' => [
			'useFile' => false, //Whether to use a generate feed file instead of generating a feed for each request.
			'filepath' => 'webroot/product_feed.xml', //The filepath to the generated feed file.
			'brand' => null, //The fallback brand to use on products when no brand is set.
			'category' => null, //The fallback category to use on products when no category is set.
			'useHierarchicalCategories' => false, //Set to true to include up to 5 categories and their parents as hierarchical lists.
			'hierarchicalCategoryLimit' => 5, //Set the amount of category hierarchies to include.
			'minImageWidth' => 100, //The minimum width an image needs to be used to the google shopping feed.
			'minImageHeight' => 100, //The minimum height an image needs to be used on the google shopping feed.
		],

		'route' => array(
			'Brand' => array(
				'controller' => 'ev_shop.brands',
				'action' => 'view',
				'plugin' => 'EvShop'
			),

			'Category' => array(
				'controller' => 'ev_shop.categories',
				'action' => 'view',
				'plugin' => 'EvShop'
			),

			'Product' => array(
				'controller' => 'ev_shop.products',
				'action' => 'view',
				'plugin' => 'EvShop'
			)
		),

		'displayTaxAsVat' => true,

		// set to true to allow admin users to edit additional data per product option
		'manageOptions' => false,
		'managedOptionsHaveImages' => true,

		// flag to determine whether variant imagery is used throughout the plugin
		'hasVariantImagery' => true,

		// Set this to activate colour specific filter options
		//'colorOptionGroupId' => 1,

		// defines whether brands have a parent hierarchy on the site
		'brandsHaveParents' => false,

		// Determines whether products belonging to sub-brands should be pulled out when a parent brand is selected
		'showSubBrandProducts' => false,

		// Set this to the name of a cache config to enable product caching. See https://book.cakephp.org/2.0/en/core-libraries/caching.html#configuring-cache-class to set up a cache config.
		// This should be a dedicated cache config as it will be completely cleared in some instances.
		// This will currently cache product option paths which can greatly improve the load speed of the product view page.
		// If any additional data is added to the path make sure to clear the cache on save otherwise it will become outdated.
		'productCacheName' => false,


		// You can optionally define a list of field types for your product option groups. These can be selected via the
		// admin area when creating/editing option groups. An associated element is then used on the frontend for handling
		// the display of that option.
		//
		// An example of when you'd use this is if you have a product that has a size (which would be a select box) and
		// a colour (which would be a custom radio style colour picker).
		//
		// The elements to handle the display are located in EvShop/View/Elements/OptionGroupFields/ and are based on the
		// key from each array line. Examples of these can be found in the plugin.
		//
		// You can leave this array empty if you dont wish to use this feature.
		'optionGroupFieldTypes' => [
			//'select' => 'Drop-down select box',
			//'color' => 'Colour Picker',
			//'radio' => 'Radio button list'
		],

		// When using filters, category overrides can be used to override the content in a category to make it specific
		// for a set of filters.
		'useCategoryOverrides' => false,

		// Allow a user provided query request parameter to override page content. For example, while on a category
		// view page, if a user provides a query parameter of "t" then the category title will be replaced with the
		// value of "t".
		'allowQueryOverrides' => false,
		'categoryTitleParam' => 't',

		// Prefer RRP when showing the "Was" price on a Sale item
		// This is purely a display change and does not affect basket calculations
		// FALSE by default, TRUE for older sites which showed the RRP over the Price for the "Was" price
		'preferRrpForWasPrice' => false,

		// The lowest price stores the lowest purchasable price for a variant (price/sale price). It also includes tax
		// price for a variant if it can be added. Defaults to true for sites incVAT. For sites that are exVAT, set to
		// false.
		'lowestPriceIncVat' => true,
	)
);
