<?php

class AddLevelToCategories extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_level_to_categories';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = [
		'up' => [
			'create_field' => [
				'ev_shop_categories' => [
					'level' => ['type' => 'integer', 'unsigned' => true, 'null' => true, 'default' => null, 'after' => 'rght'],
				],
			],
		],
		'down' => [
			'drop_field' => [
				'ev_shop_categories' => [
					'level',
				],
			],
		],
	];

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'down') {
			return true;
		}

		$Category = EvClassRegistry::init('EvShop.Category');

		$batchSize = 100;
		$batchOffset = 0;

		$queryParams = [
			'limit' => $batchSize,
			'offset' => $batchOffset,
		];

		$categoryCount = $Category->find(
			'count',
			$queryParams
		);

		while ($categoryCount !== false && $categoryCount > 0) {
			$categories = $Category->find(
				'all',
				$queryParams
			);

			$Category->saveMany($categories);

			$queryParams['offset'] += $batchSize;

			$categoryCount = $Category->find(
				'count',
				$queryParams
			);
		}

		return true;
	}
}
