<?php

class AddProductAttributeIndexes extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_product_attribute_indexes';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = [
		'up' => [
			'create_field' => [
				'ev_shop_product_attribute_groups' => [
					'indexes' => [
						'product_attribute_group_system_name' => ['column' => 'system_name', 'unique' => true],
					],
				],
				'ev_shop_product_attributes' => [
					'indexes' => [
						'fk_product_attributes_product_attribute_group_id' => ['column' => 'product_attribute_group_id', 'unique' => false],
					],
				],
				'ev_shop_product_attributes_products' => [
					'indexes' => [
						'fk_product_attributes_products_product_id' => ['column' => 'product_id', 'unique' => false],
						'fk_product_attributes_products_attribute_id' => ['column' => 'product_attribute_id', 'unique' => false],
					],
				],
			],
		],
		'down' => [
			'drop_field' => [
				'ev_shop_product_attribute_groups' => [
					'indexes' => [
						'product_attribute_group_system_name',
					],
				],
				'ev_shop_product_attributes' => [
					'indexes' => [
						'fk_product_attributes_product_attribute_group_id',
					],
				],
				'ev_shop_product_attributes_products' => [
					'indexes' => [
						'fk_product_attributes_products_product_id',
						'fk_product_attributes_products_attribute_id',
					],
				],
			],
		],
	];

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
