<?php

class AllowCategoryOverrideBrandIdTobeNull extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'allow_category_override_brand_id_to_be_null';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = [
		'up' => [
			'alter_field' => [
				'ev_shop_category_overrides' => [
					'brand_id' => ['null' => true, 'default' => null],
				],
			],
		],
		'down' => [
			'alter_field' => [
				'ev_shop_category_overrides' => [
					'brand_id' => ['null' => false, 'default' => null],
				],
			],
		],
	];

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
