<?php

class AddCategoryOverridesProductAttributesTable extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_category_overrides_product_attributes_table';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = [
		'up' => [
			'create_table' => [
				'ev_shop_category_overrides_product_attributes' => [
					'id' => ['type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'primary'],
					'category_override_id' => ['type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'index'],
					'product_attribute_id' => ['type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'index'],
					'indexes' => [
						'PRIMARY' => ['column' => 'id', 'unique' => true],
						'fk_category_overrides_product_attributes_category_override_id' => ['column' => 'category_override_id', 'unique' => false],
						'fk_category_overrides_product_attributes_product_attribute_id' => ['column' => 'product_attribute_id', 'unique' => false],
					],
				],
			],
		],
		'down' => [
			'drop_table' => [
				'ev_shop_category_overrides_product_attributes',
			],
		],
	];

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
