<?php

class CreateCategoryOverrideTables extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'create_category_override_tables';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = [
		'up' => [
			'create_table' => [
				'ev_shop_category_overrides' => [
					'id' => ['type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'primary'],
					'override_hash' => ['type' => 'string', 'null' => true, 'default' => null, 'length' => 100, 'collate' => 'utf8mb4_unicode_ci', 'charset' => 'utf8mb4', 'key' => 'index'],
					'category_id' => ['type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'index'],
					'brand_id' => ['type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'index'],
					'name' => ['type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_unicode_ci', 'charset' => 'utf8mb4'],
					'body' => ['type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_unicode_ci', 'charset' => 'utf8mb4'],
					'meta_title' => ['type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_unicode_ci', 'charset' => 'utf8mb4'],
					'meta_description' => ['type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_unicode_ci', 'charset' => 'utf8mb4'],
					'created' => ['type' => 'datetime', 'null' => true, 'default' => null],
					'modified' => ['type' => 'datetime', 'null' => true, 'default' => null],
					'indexes' => [
						'PRIMARY' => ['column' => 'id', 'unique' => true],
						'override_hash' => ['column' => 'override_hash', 'unique' => true],
						'fk_category_overrides_categories_category_id' => ['column' => 'category_id', 'unique' => false],
						'fk_category_overrides_categories_brand_id' => ['column' => 'brand_id', 'unique' => false],
					],
					'tableParameters' => ['charset' => 'utf8mb4', 'collate' => 'utf8mb4_unicode_ci', 'engine' => 'InnoDB'],
				],
				'ev_shop_category_overrides_options' => [
					'id' => ['type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'primary'],
					'category_override_id' => ['type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'index'],
					'option_id' => ['type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'index'],
					'indexes' => [
						'PRIMARY' => ['column' => 'id', 'unique' => true],
						'fk_category_overrides_options_category_override_id' => ['column' => 'category_override_id', 'unique' => false],
						'fk_category_overrides_options_option_id' => ['column' => 'option_id', 'unique' => false],
					],
				],
			],
		],
		'down' => [
			'drop_table' => [
				'ev_shop_category_overrides',
				'ev_shop_category_overrides_options',
			],
		],
	];

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
