<?php

class AddIndexesToVariantPricing extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_indexes_to_variant_pricing';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = [
		'up' => [
			'create_field' => [
				'ev_shop_variant_pricings' => [
					'indexes' => [
						'variant' => ['column' => 'variant_id', 'unique' => false],
						'currency_id' => ['column' => 'currency_id', 'unique' => false],
						'lowest_price' => ['column' => 'lowest_price', 'unique' => false],
						'variant_currency_price' => ['column' => ['variant_id', 'currency_id', 'lowest_price'], 'unique' => false]
					],

				],
			],
		],
		'down' => [
			'drop_field' => [
				'ev_shop_variant_pricings' => [
					'indexes' => [
						'variant', 'currency_id', 'lowest_price', 'variant_currency_price'
					],
				],
			],
		],
	];

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 *
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 *
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
