<?php

App::uses('UpdatePricingShell', 'EvShop.Console/Command');

class AddLowestPriceFieldToVariantPricings extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_lowest_price_field_to_variant_pricings';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'ev_shop_variant_pricings' => array(
					'lowest_price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false, 'after' => 'trade_price'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'ev_shop_variant_pricings' => array('lowest_price'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$dispatcher = new UpdatePricingShell();
			$dispatcher->update();
		}

		return true;
	}
}
