<?php

App::uses('AppHelper', 'View/Helper');

App::uses('HtmlHelper', 'View/Helper');

class ProductHelper extends AppHelper {

	public $helpers = array('Html', 'Image');

/**
 * Returns a URL for the given product
 * @param 	array $product The product array 
 * @return 	array The url array
 */
	public function getProductUrl($product) {

		return $this->Html->url($this->getProductRoute($product));
		
	}

/**
 * Returns the route for the given product in a form to Router::url
 * @param 	array $product The product array 
 * @return 	array The url array
 */
	public function getProductRoute($product) {

		//Extract ID
		$productId = $this->_getProductId($product);

		return array(
			'plugin' => 'ev_shop', 
			'controller' => 'products', 
			'action' => 'view', 
			$productId
		); 

	}

/**
 * Used to get the product thumbnail, 
 * This will try and use the listing image first
 * and if not available will use the first main image
 * @param  array $product Product Array
 * @param  array $imageParams Image params as passed to ImageHelper::resize
 * @return Produces an image html tag
 */
	public function getListingImage($product, $imageParams = array()) {

		if(isset($product['ListingImage'][0])) {

			$image = $product['ListingImage'][0];

		} elseif(isset($product['Image'][0])) {

			$image = $product['Image'][0];

		} else {

			$image = 'no-image';
			
		}

		return $this->Image->resize(
			$image, 
			$imageParams
		); 

	}


	protected function _getProductId($product) {

		if(! isset($product['id'])) {

			if(isset($product['Product']['id'])) {

				$product = $product['Product']; 

			} else {

				throw new NotFoundException("Product ID could not be found", 1);
				
			}

		}

		return $product['id'];

	}

}