<?php
	echo $this->Form->addField('ProductAttributeOption.ProductAttributeOption', array(
		'type' => 'hidden',
		'value' => false
	));

	$selectedProductAttributeOptions = !empty($this->request->data['ProductAttributeOption']) ? Hash::extract($this->request->data['ProductAttributeOption'], '{n}.id') : [];

	foreach ($productAttributes as $attributeKey => $productAttribute) {

		echo $this->Html->tag('h3', $productAttribute['ProductAttribute']['name']);

		if ($productAttribute['ProductAttribute']['affects_price']) {

			foreach ($productAttribute['ProductAttributeOption'] as $optionKey=>$productAttributeOption) {

				echo $this->Form->addField(
					'ProductAttributeOption.ProductAttributeOption.' . $attributeKey . '-' . $optionKey,
					array(
						'type' => 'boolean',
						'value' => $productAttributeOption['id'],
						'label' => $productAttributeOption['name'],
						'hiddenField' => false,
						'checked' => in_array($productAttributeOption['id'], $selectedProductAttributeOptions)
					)
				);

			}

		} else {

			// Work out if one of the options is selected by checking the intersect between
			// This attributes options and the products selected attributes
			$selectedAttributeOptions = array_intersect($selectedProductAttributeOptions, Hash::extract($productAttribute['ProductAttributeOption'], '{n}.id'));

			echo $this->Form->addField(
				'ProductAttributeOption.ProductAttributeOption.' . $attributeKey,
				array(
					'type' => 'select',
					'options' => Hash::combine($productAttribute['ProductAttributeOption'], '{n}.id', '{n}.name'),
					'label' => $productAttribute['ProductAttribute']['name'],
					'empty' => 'Not Applicable',
					'selected' => array_pop($selectedAttributeOptions)
				)
			);

		}

	}