<?php

class EvShopAppModel extends AppModel {
	
	public $tablePrefix = "ev_shop_";

	
	public $cacheQueries = true;


    public function __construct($id = false, $table = null, $ds = null) {

        //Setup model relationship overrides 
        if(Configure::read('EvShop.ModelOverride')) {

            $modelOverrides = Configure::read('EvShop.ModelOverride');

            //Loop through hasMany, belongsTo, ....
            foreach($this->_associationKeys as $relationshipType => $relationship) {
                
                //Loop through each relationship
                foreach($this->$relationshipType as $modelAlias=>$relationshipParams) {

                    //Work out the model that association uses 
                    $className = isset($relationshipParams['className']) ? $relationshipParams['className'] : $modelAlias;

                    if(array_key_exists($className, $modelOverrides)) {

                        $this->{$relationshipType}[$modelAlias]['className'] = $modelOverrides[$className]; 

                    }

                }

            }

        }

        parent::__construct($id, $table, $ds);

        return;

    }

	
 	/** 
     * Makes a subquery 
     * @param strin|array $type The type o the query (only available 'count') or the $options 
     * @param string|array $options The options array or $alias in case of $type be a array 
     * @param string $alias You can use this intead of $options['alias'] if you want 
     */ 
    public function subquery($options = null){ 
                 
        $dbo = $this->getDataSource(); 
                 
        $default = array( 
            'table' => $dbo->fullTableName($this), 
            'alias' => $this->alias, 
            'limit' => null, 
            'offset' => null, 
            'joins' => array(), 
            'conditions' => array(), 
            'order' => null, 
            'group' => null 
        ); 
         
        $params = array_merge($default, $options); 
        $subQuery = $dbo->buildStatement($params, $this); 
         
        return $subQuery; 
    }



}