<?php if (! empty($this->request->data['Variant'])): ?>
	<div class="sortable">

		<?php $open = ' open'; ?>
		<?php if (count($this->request->data['Variant']) > 1): ?>
			<div class="flash flash--info flash--condensed">
				<h2 class='flash__title'>Drag variants to reorder.</h2>
			</div>
			<?php
				$open = false;
				$this->Html->script(
					array('EvShop.variantsManage'),
					array('inline' => false)
				);
			?>
		<?php endif; ?>

		<?php foreach ($this->request->data['Variant'] as $key => $Variant): ?>
			<?php
				$options = array();
				if (isset($Variant['Option']) && ! empty($Variant['Option'])):
					foreach ($Variant['Option'] as $option):
						$options[] = $option['id'];
					endforeach;
				endif;
			?>

			<fieldset class="collapsable-fieldset<?=$open?> variant-record" data-variant="<?=$Variant['id']?>" data-options="<?=implode(",", $options)?>">
				<legend>
					<?php
						// manually assign the variant name to a hidden field so
						// it is submitted with other request data and returns
						// on failed form submissions
						echo $this->Form->input('Variant.' . $key . '.name', [
							'type' => 'hidden',
						]);

						echo (isset($Variant['name']) ? $Variant['name'] : '');
					?>
				</legend>
				<div class="container-fluid">
					<div class="row">
						<div class="col-xs-12 col-md-5">
							<?php
								if (isset($Variant['desc_temp'])) {
									$this->request->data['Variant'][$key]['option_desc'] = $Variant['desc_temp'];
								}

								//Display any fields that aren't in the following array
								$removeFieldsArray = array('Variant.name', 'Variant.sku', 'Variant.is_active');
								foreach ($fields as $field => $attr):
									if (in_array($field, $removeFieldsArray)):
										continue;
									endif;

									$attr['label']['class'] = 'col-xs-12 col-md-5 control-label';
									$attr['wrapInput'] = 'col-xs-12 col-md-7 form-control-readonly';

		                            echo $this->Form->addField(
		                                'Variant.' . $key . '.' . substr($field, strpos($field, '.') + 1),
		                                $attr
		                            );
								endforeach;

								echo $this->Form->addField(
									'Variant.' . $key . '.desc_temp',
									[
										'type' => 'hidden',
										'value' => isset($Variant['option_desc']) ? $Variant['option_desc'] : $Variant['desc_temp']
									]
								);

								echo $this->Form->addField(
									'Variant.' . $key . '.id',
									[
										'type' => 'string'
									]
								);

								echo $this->Form->addField(
									'Variant.' . $key . '.product_id',
									[
										'type' => 'hidden'
									]
								);

								//SKU field
								echo $this->Form->addField('Variant.' . $key . '.sku', [
									'label' => [
										'class' => 'col-xs-12 col-md-5 control-label',
										'text' => 'SKU'
									],
									'type' => 'string',
									'wrapInput' => 'col-xs-12 col-md-7'
								]);

								//Cost field
								$cost = null;
								if (isset($Variant['cost'])):
									$roundedPrice = $this->Number->precision($Variant['cost'], 3);
									if (substr(strval($roundedPrice), -1) == 0) {
										$cost = $this->Number->precision($Variant['cost'], 2);
									} else {
										$cost = $roundedPrice;
									}
								endif;

								echo $this->Form->addField('Variant.' . $key . '.cost', [
										'label' => [
											'class' => 'control-label col-xs-12 col-md-5'
										],
										'type' => 'decimal',
										'value' => $cost,
										'wrapInput' => 'col-xs-12 col-md-7'
									]);

								if (CakePlugin::loaded('EvInventory')) {
									echo $this->Form->addField(
										'Variant.' . $key . '.Inventory.id',
										array(
											'type' => 'integer'
										)
									);

									echo $this->Form->addField(
										'Variant.' . $key . '.Inventory.stock',
										array(
											'type' => 'integer'
										)
									);

									echo $this->Form->addField(
										'Variant.' . $key . '.Inventory.warning_level',
										array(
											'type' => 'integer',
											'class' => 'beforeCheckbox'
										)
									);
								}

								//Is active field
								echo $this->Form->addField(
									'Variant.' . $key . '.is_active',
									[
										'wrapInput' => 'col-xs-12 col-md-9 col-md-offset-3 col-lg-7 col-lg-offset-5',
										'type' => 'boolean',
									]
								);
							?>
						</div>
						<div class="col-xs-12 col-md-7 manage-stock-options">
							<?php
								if (CakePlugin::loaded('EvInventory')) {
									//Rest of stock control options that haven't been displayed yet

									//Wrapping each in a div to stop them interfering with each other
									echo '<div class="col-xs-12">';
									echo $this->Form->addField(
										'Variant.' . $key . '.Inventory.warning_action',
										array(
											'type' => 'multicheck',
											'label' => 'When warning stock level reached:',
											'options' => Configure::read('EvInventory.warningActions')
										)
									);
									echo '</div>';

									echo '<div class="col-xs-12">';
									echo $this->Form->addField(
										'Variant.' . $key . '.Inventory.oos_action',
										array(
											'type' => 'multicheck',
											'label' => 'When out of stock:',
											'options' => Configure::read('EvInventory.oosActions')
										)
									);
									echo '</div>';
								}
							?>
						</div>
					</div>
					<?php if(! empty($currencies)): ?>
						<div class="row">
							<div class="col-xs-12">
								<?php
								foreach ($currencies as $currencyId => $currencyName):
									if (Configure::read('EvShop.autoManageCurrencies') == true && isset($defaultCurrency) && $currencyId != $defaultCurrency):
										continue;
									endif;
								?>
									<div class="col-xs-12">
										<fieldset class="">
											<legend>Currency: <?php echo $currencyName; ?></legend>
											<div class="container-fluid">
												<div class="row transition-none">
													<?php
														$priceId = null;
														if (isset($Variant['VariantPricing'][$currencyId]['od'])):
															$priceId = $Variant['VariantPricing'][$currencyId]['id'];
														endif;
														echo $this->Form->addField(
															'Variant.' . $key . '.VariantPricing.' . $currencyId . '.id',
															array(
																'type' => 'hidden',
																'value' => $priceId
															)
														);

														echo $this->Form->addField(
															'Variant.' . $key . '.VariantPricing.' . $currencyId . '.currency_id',
															array(
																'type' => 'hidden',
																'value' => $currencyId
															)
														);

														$taxLabelAsVat = Configure::read('EvShop.displayTaxAsVat');
														$taxLabel = 'Tax';
														if ($taxLabelAsVat) {
															$taxLabel = 'VAT';
														}
													?>

													<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3">
														<?php
															$rrp = null;
															if (isset($Variant['VariantPricing'][$currencyId]['rrp'])):
																$roundedPrice = $this->Number->precision($Variant['VariantPricing'][$currencyId]['rrp'], 3);
																if (substr(strval($roundedPrice), -1) == 0) {
																	$rrp = $this->Number->precision($Variant['VariantPricing'][$currencyId]['rrp'], 2);
																} else {
																	$rrp = $roundedPrice;
																}
															endif;

															//Taxrate is a required field so would always be set, check if tax is set higher than 0
															$taxRate = null;
															if (isset($Variant['Product']['TaxLevel']['rate']) && $Variant['Product']['TaxLevel']['rate'] > 0) {
																$taxRate = $Variant['Product']['TaxLevel']['rate'];
															}

															$rrpFieldAttr = [
																'type' => 'input',
																'label' => [
																	'class' => 'col-xs-12 col-lg-6 control-label'
																],
																'value' => $rrp,
																'data-type' => 'currency',
																'data-field' => 'rrp',
																'data-taxrate' => $taxRate,
																'data-currency' => $currencyId,
																'data-taxlabel' => $taxLabelAsVat,
																'wrapInput' => 'col-xs-12 col-lg-6'
															];

															// multiple rrp fields required
															if ($taxRate !== null && $taxRate > 1):
																echo $this->Html->tag(
																	'label',
																	'RRP',
																	[
																		'class' => 'col-xs-12'
																	]
																);

																$rrpFieldAttr['label']['text'] = 'ex. ' . $taxLabel;
															else:
																$rrpFieldAttr['label']['text'] = 'RRP (ex. ' . $taxLabel . ')';
															endif;

															echo $this->Form->addField(
																'Variant.' . $key . '.VariantPricing.' . $currencyId . '.rrp',
																$rrpFieldAttr
															);
														?>
													</div>
													<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3">
														<?php
															$price = null;
															if (isset($Variant['VariantPricing'][$currencyId]['price'])):
																$roundedPrice = $this->Number->precision($Variant['VariantPricing'][$currencyId]['price'], 3);
																if (substr(strval($roundedPrice), -1) == 0) {
																	$price = $this->Number->precision($Variant['VariantPricing'][$currencyId]['price'], 2);
																} else {
																	$price = $roundedPrice;
																}
															endif;

															$taxRate = null;
															if (isset($Variant['Product']['TaxLevel']['rate']) && $Variant['Product']['TaxLevel']['rate'] > 0) {
																$taxRate = $Variant['Product']['TaxLevel']['rate'];
															}

															$priceFieldAttr = [
																'type' => 'input',
																'value' => $price,
																'data-type' => 'currency',
																'data-field' => 'price',
																'data-taxrate' => $taxRate,
																'data-currency' => $currencyId,
																'data-taxlabel' => $taxLabelAsVat,
																'label' => [
																	'class' => 'col-xs-12 col-lg-6 control-label'
																],
																'wrapInput' => 'col-xs-12 col-lg-6'
															];

															// multiple rrp fields required
															if ($taxRate !== null && $taxRate > 1):
																echo $this->Html->tag(
																	'label',
																	'Price',
																	[
																		'class' => 'col-xs-12'
																	]
																);

																$priceFieldAttr['label']['text'] = 'ex. ' . $taxLabel;
															else:
																$priceFieldAttr['label']['text'] = 'Price (ex. ' . $taxLabel . ')';
															endif;

															echo $this->Form->addField(
																'Variant.' . $key . '.VariantPricing.' . $currencyId . '.price',
																$priceFieldAttr
															);
														?>
													</div>
													<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3">
														<?php
															$sale_price = null;
															if (isset($Variant['VariantPricing'][$currencyId]['sale_price'])):
																$roundedPrice = $this->Number->precision($Variant['VariantPricing'][$currencyId]['sale_price'], 3);
																if (substr(strval($roundedPrice), -1) == 0) {
																	$sale_price = $this->Number->precision($Variant['VariantPricing'][$currencyId]['sale_price'], 2);
																} else {
																	$sale_price = $roundedPrice;
																}
															endif;

															$taxRate = null;
															if (isset($Variant['Product']['TaxLevel']['rate']) && $Variant['Product']['TaxLevel']['rate'] > 0) {
																$taxRate = $Variant['Product']['TaxLevel']['rate'];
															}

															$salePriceFieldAttr = [
																'type' => 'input',
																'label' => 'ex. ' . $taxLabel,
																'value' => $sale_price,
																'data-type' => 'currency',
																'data-field' => 'sale_price',
																'data-taxrate' => $taxRate,
																'data-currency' => $currencyId,
																'data-taxlabel' => $taxLabelAsVat,
																'label' => [
																	'class' => 'col-xs-12 col-lg-6 control-label'
																],
																'wrapInput' => 'col-xs-12 col-lg-6'
															];

															// multiple rrp fields required
															if ($taxRate !== null && $taxRate > 1):
																echo $this->Html->tag(
																	'label',
																	'Sale Price',
																	[
																		'class' => 'col-xs-12'
																	]
																);

																$salePriceFieldAttr['label']['text'] = 'ex. ' . $taxLabel;
															else:
																$salePriceFieldAttr['label']['text'] = 'Sale Price (ex. ' . $taxLabel . ')';
															endif;

															echo $this->Form->addField(
																'Variant.' . $key . '.VariantPricing.' . $currencyId . '.sale_price',
																$salePriceFieldAttr
															);
														?>
													</div>
													<?php
														if (! empty(Configure::read('SiteSetting.ev_shop.enable_trade_pricing'))):
													?>
															<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3">
																<?php
																	$trade_price = null;
									                                if (isset($Variant['VariantPricing'][$currencyId]['trade_price'])):
									                                    $roundedPrice = $this->Number->precision($Variant['VariantPricing'][$currencyId]['trade_price'], 3);
																		if (substr(strval($roundedPrice), -1) == 0) {
																			$trade_price = $this->Number->precision($Variant['VariantPricing'][$currencyId]['trade_price'], 2);
																		} else {
																			$trade_price = $roundedPrice;
																		}
									                                endif;

									                                $taxRate = null;
																	if (isset($Variant['Product']['TaxLevel']['rate']) && $Variant['Product']['TaxLevel']['rate'] > 0) {
																		$taxRate = $Variant['Product']['TaxLevel']['rate'];
																	}

																	$tradePriceFieldAttr = [
																		'type' => 'input',
								                                        'label' => 'ex. ' . $taxLabel,
								                                        'value' => $trade_price,
								                                        'data-type' => 'currency',
								                                        'data-field' => 'trade_price',
								                                        'data-taxrate' => $taxRate,
								                                        'data-currency' => $currencyId,
								                                        'data-taxlabel' => $taxLabelAsVat,
																		'label' => [
																			'class' => 'col-xs-12 col-lg-6 control-label'
																		],
																		'wrapInput' => 'col-xs-12 col-lg-6'
																	];

																	// multiple rrp fields required
																	if ($taxRate !== null && $taxRate > 1):
																		echo $this->Html->tag(
																			'label',
																			'Trade Price',
																			[
																				'class' => 'col-xs-12'
																			]
																		);

																		$tradePriceFieldAttr['label']['text'] = 'ex. ' . $taxLabel;
																	else:
																		$tradePriceFieldAttr['label']['text'] = 'Trade Price (ex. ' . $taxLabel . ')';
																	endif;

									                                echo $this->Form->addField(
									                                    'Variant.' . $key . '.VariantPricing.' . $currencyId . '.trade_price',
									                                    $tradePriceFieldAttr
									                                );
																?>
															</div>
													<?php
														endif;
													?>
												</div>
											</div>
										</fieldset>
									</div>
								<?php
									endforeach;
								?>
							</div>
						</div>
					<?php endif; ?>
				</div>
			</fieldset>
		<?php endforeach; ?>
	</div>
<?php endif; ?>

<?php
	echo $this->Html->script(
		array(
			'EvShop.autoNumeric.min.js',
			'EvShop.variantPricing.js'
		),
		array(
			'inline' => false
		)
	);

	echo $this->Html->css(
		array(
			'EvShop.manage.css'
		),
		array(
			'inline' => false
		)
	);
?>
