<?php
/**
 * VariantFixture
 *
 */
class OptionsVariantFixture extends CakeTestFixture {

	public $table = 'ev_shop_options_variants';

/**
 * Fields
 *
 * @var array
 */
	public $fields = array(
		'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'primary'),
		'option_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
		'variant_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
		'indexes' => array(
			'PRIMARY' => array('column' => 'id', 'unique' => 1),
			'fk_variants_options1_idx' => array('column' => 'option_id', 'unique' => 0),
			'fk_variants_options2_idx' => array('column' => 'variant_id', 'unique' => 0)
		),
		'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB')
	);

/**
 * Records
 *
 * @var array
 */
	public $records = array(
		array(
			'id' => 1,
			'option_id' => 1,
			'variant_id' => 1
		),
		array(
			'id' => 2,
			'option_id' => 4,
			'variant_id' => 1
		),
		array(
			'id' => 3,
			'option_id' => 2,
			'variant_id' => 2
		),
		array(
			'id' => 4,
			'option_id' => 4,
			'variant_id' => 2
		)
	);
}
