<?php
/**
 * OptionFixture
 *
 */
class OptionFixture extends CakeTestFixture {

	public $table = 'ev_shop_options';

/**
 * Fields
 *
 * @var array
 */
	public $fields = array(
		'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'primary'),
		'option_group_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
		'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
		'sequence' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 5, 'unsigned' => false),
		'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'indexes' => array(
			'PRIMARY' => array('column' => 'id', 'unique' => 1),
			'fk_attributes_variants1_idx' => array('column' => 'option_group_id', 'unique' => 0)
		),
		'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB')
	);

/**
 * Records
 *
 * @var array
 */
	public $records = array(
		array(
			'id' => 1,
			'option_group_id' => 1,
			'name' => 'Red',
			'sequence' => 0,
			'created' => '2015-07-09 14:20:06',
			'modified' => '2015-07-09 14:20:06'
		),
		array(
			'id' => 2,
			'option_group_id' => 1,
			'name' => 'Blue',
			'sequence' => 1,
			'created' => '2015-07-09 14:20:06',
			'modified' => '2015-07-09 14:20:06'
		),
		array(
			'id' => 3,
			'option_group_id' => 2,
			'name' => 'Small',
			'sequence' => 0,
			'created' => '2015-07-09 14:20:06',
			'modified' => '2015-07-09 14:20:06'
		),
		array(
			'id' => 4,
			'option_group_id' => 3,
			'name' => 'Matte',
			'sequence' => 0,
			'created' => '2015-07-09 14:20:06',
			'modified' => '2015-07-09 14:20:06'
		),
		array(
			'id' => 5,
			'option_group_id' => 3,
			'name' => 'Gloss',
			'sequence' => 1,
			'created' => '2015-07-09 14:20:06',
			'modified' => '2015-07-09 14:20:06'
		),
	);

}
