<?php
/**
 * CategoriesProductFixture
 *
 */
class CategoriesProductFixture extends CakeTestFixture {

	public $table = 'ev_shop_categories_products';

/**
 * Fields
 *
 * @var array
 */
	public $fields = array(
		'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
		'category_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
		'product_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
		'sequence' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 5, 'unsigned' => false),
		'indexes' => array(
			'PRIMARY' => array('column' => 'id', 'unique' => 1),
			'fk_categories_products_categories1_idx' => array('column' => 'category_id', 'unique' => 0),
			'fk_categories_products_products1_idx' => array('column' => 'product_id', 'unique' => 0)
		),
		'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_general_ci', 'engine' => 'InnoDB')
	);

	public $records = array(
		array(
			'id' => 1,
			'category_id' => 1,
			'product_id' => 1,
			'sequence' => 10
		),
		array(
			'id' => 2,
			'category_id' => 1,
			'product_id' => 2,
			'sequence' => 5
		),
		array(
			'id' => 3,
			'category_id' => 2,
			'product_id' => 2,
			'sequence' => 10
		),
		array(
			'id' => 4,
			'category_id' => 1,
			'product_id' => 3,
			'sequence' => 20
		)
	);

}
