<?php
App::uses('Category', 'Model');

/**
 * Category Test Case
 *
 */
class CategoryTest extends CakeTestCase {

/**
 * Fixtures
 *
 * @var array
 */
	public $fixtures = array(
		'plugin.EvShop.category',
		'plugin.EvShop.product',
		//'plugin.EvShop.categories_product'
	);

/**
 * setUp method
 *
 * @return void
 */
	public function setUp() {
		parent::setUp();
		$this->Category = ClassRegistry::init('EvShop.Category');
	}

/**
 * tearDown method
 *
 * @return void
 */
	public function tearDown() {
		unset($this->Category);

		parent::tearDown();
	}

	public function testProcessDeletedCategoriesMarksTheCorrectRowsForDeletion() {
		$categories = array(
			array(
				'id' => 1,
				'category_id' => 5
			),
			array(
				'id' => 3,
				'category_id' => 6
			),
			array(
				'id' => 4
			),
			array(
				'id' => 5,
				'category_id' => 10
			),
			array(
				'id' => 6
			),
			array(
				'id' => 7,
				'category_id' => 12
			)
		);

		$this->assertEquals(
			$this->Category->processDeletedCategories(
				$categories
			),
			array(
				4, 6
			)
		);
	}
}
