<?php
App::uses('AppController', 'Controller');
App::uses('CakeRequest', 'Network');
App::uses('CakeResponse', 'Network');
App::uses('ComponentCollection', 'Controller');
App::uses('ProductsComponent', 'EvShop.Controller/Component');

// A fake controller to test against
class ProdutsControllerTest extends AppController {

}


class ProductsComponentTest extends CakeTestCase {

	public $ProductsComponent = null;

	public $Controller = null;

	/**
	 * Fixtures
	 *
	 * @var array
	 */
	public $fixtures = array(
		'plugin.EvCore.image',
		'plugin.EvCustomFields.fields',
		'plugin.EvCustomFields.field_data',
		'plugin.MetaData.meta_data',
		'plugin.EvShop.product',
		'plugin.EvShop.brand',
		'plugin.EvShop.variant',
		'plugin.EvShop.category',
		'plugin.EvShop.categories_product'
	);

	/**
	 * setUp method
	 *
	 * @return void
	 */
	public function setUp() {
		parent::setUp();
		// Setup our component and fake test controller
		$Collection = new ComponentCollection();
		$this->ProductsComponent = new ProductsComponent($Collection);
		$CakeRequest = new CakeRequest();
		$CakeResponse = new CakeResponse();
		$this->Controller = new ProdutsControllerTest($CakeRequest, $CakeResponse);
		$this->Controller->constructClasses();

		$this->ProductsComponent->initialize($this->Controller);
	}

	/**
	 * tearDown method
	 *
	 * @return void
	 */
	public function tearDown() {
		parent::tearDown();
		// Clean up after we're done
		unset($this->ProductsComponent);
		unset($this->Controller);
	}

	public function testListingReturnsAllActiveProductsAndDataWithNoParamsPassedAndWhenPagingDisabled() {
		$expected = array(
			array(
				'Product' => array(
					'id' => '2',
					'name' => 'My Product 2',
					'description' => 'Second product',
					'brand_id' => '1',
					'tax_level_id' => '1',
					'template_id' => '1',
					'is_active' => true,
					'is_featured' => true,
					'created' => '2015-07-09 14:20:55',
					'modified' => '2015-07-09 14:20:55'
				),
				'Variant' => array(
					array(
						'id' => '3',
						'product_id' => '2',
						'name' => 'My Product 2',
						'sku' => 'qweqweqwe',
						'rrp' => '0.000000',
						'price' => '0.000000',
						'sale_price' => '0.000000',
						'sequence' => '1',
						'is_active' => true,
						'created' => '2015-07-09 14:25:34',
						'modified' => '2015-07-09 14:25:34'
					)
				),
				'ListingImage' => array()
			),
			array(
				'Product' => array(
					'id' => '1',
					'name' => 'My Product 1',
					'description' => 'Lorem ipsum dolor sit amet, aliquet feugiat. Convallis morbi fringilla gravida, phasellus feugiat dapibus velit nunc, pulvinar eget sollicitudin venenatis cum nullam, vivamus ut a sed, mollitia lectus. Nulla vestibulum massa neque ut et, id hendrerit sit, feugiat in taciti enim proin nibh, tempor dignissim, rhoncus duis vestibulum nunc mattis convallis.',
					'brand_id' => '2',
					'tax_level_id' => '1',
					'template_id' => '1',
					'is_active' => true,
					'is_featured' => false,
					'created' => '2015-07-09 14:20:55',
					'modified' => '2015-07-09 14:20:55'
				),
				'Variant' => array(
					array(
						'id' => '2',
						'product_id' => '1',
						'name' => 'Blue Matte',
						'sku' => 'Lorem ipsum dolor sit amet',
						'rrp' => '0.000000',
						'price' => '0.000000',
						'sale_price' => '0.000000',
						'sequence' => '1',
						'is_active' => true,
						'created' => '2015-07-09 14:25:34',
						'modified' => '2015-07-09 14:25:34'
					),
					array(
						'id' => '1',
						'product_id' => '1',
						'name' => 'Red Matte',
						'sku' => 'Lorem ipsum dolor sit amet',
						'rrp' => '0.000000',
						'price' => '0.000000',
						'sale_price' => '0.000000',
						'sequence' => '2',
						'is_active' => true,
						'created' => '2015-07-09 14:25:34',
						'modified' => '2015-07-09 14:25:34'
					)
				),
				'ListingImage' => array()
			)
		);

		$this->assertEquals(
			$expected,
			$this->ProductsComponent->listing()
		);

		$this->assertEquals(
			$expected,
			$this->ProductsComponent->listing(array(), false)
		);
	}

	public function testFeaturedReturnsOnlyTheFeaturedProductData() {
		$expected = array(
			array(
				'Product' => array(
					'id' => '2',
					'name' => 'My Product 2',
					'description' => 'Second product',
					'brand_id' => '1',
					'tax_level_id' => '1',
					'template_id' => '1',
					'is_active' => true,
					'is_featured' => true,
					'created' => '2015-07-09 14:20:55',
					'modified' => '2015-07-09 14:20:55'
				),
				'Variant' => array(
					array(
						'id' => '3',
						'product_id' => '2',
						'name' => 'My Product 2',
						'sku' => 'qweqweqwe',
						'rrp' => '0.000000',
						'price' => '0.000000',
						'sale_price' => '0.000000',
						'sequence' => '1',
						'is_active' => true,
						'created' => '2015-07-09 14:25:34',
						'modified' => '2015-07-09 14:25:34'
					)
				),
				'ListingImage' => array()
			)
		);

		$this->assertEquals(
			$expected,
			$this->ProductsComponent->featured()

		);
	}

	public function testListingByCategoryReturnsTheProductDataWhenGivenOneCategoryId() {
		$expected = array(
			array(
				'Product' => array(
					'id' => '2',
					'name' => 'My Product 2',
					'description' => 'Second product',
					'brand_id' => '1',
					'tax_level_id' => '1',
					'template_id' => '1',
					'is_active' => true,
					'is_featured' => true,
					'created' => '2015-07-09 14:20:55',
					'modified' => '2015-07-09 14:20:55'
				),
				'Variant' => array(
					array(
						'id' => '3',
						'product_id' => '2',
						'name' => 'My Product 2',
						'sku' => 'qweqweqwe',
						'rrp' => '0.000000',
						'price' => '0.000000',
						'sale_price' => '0.000000',
						'sequence' => '1',
						'is_active' => true,
						'created' => '2015-07-09 14:25:34',
						'modified' => '2015-07-09 14:25:34'
					)
				),
				'ListingImage' => array()
			)
		);

		$this->assertEquals(
			$expected,
			$this->ProductsComponent->listingByCategory(2)

		);
	}

	public function testListingByCategoryReturnsTheProductDataWhenGivenMultipleCategoryId() {
		$expected = array(
			array(
				'Product' => array(
					'id' => '2',
					'name' => 'My Product 2',
					'description' => 'Second product',
					'brand_id' => '1',
					'tax_level_id' => '1',
					'template_id' => '1',
					'is_active' => true,
					'is_featured' => true,
					'created' => '2015-07-09 14:20:55',
					'modified' => '2015-07-09 14:20:55'
				),
				'Variant' => array(
					array(
						'id' => '3',
						'product_id' => '2',
						'name' => 'My Product 2',
						'sku' => 'qweqweqwe',
						'rrp' => '0.000000',
						'price' => '0.000000',
						'sale_price' => '0.000000',
						'sequence' => '1',
						'is_active' => true,
						'created' => '2015-07-09 14:25:34',
						'modified' => '2015-07-09 14:25:34'
					)
				),
				'ListingImage' => array(),
				'CategoriesProduct' => array(
					array(
						'id' => 2,
						'category_id' => 1,
						'product_id' => 2,
						'sequence' => 5,
						'Category' => array(
							'id' => '1',
							'parent_id' => '0',
							'lft' => '1',
							'rght' => '2',
							'name' => 'Category 1',
							'body' => 'Lorem ipsum dolor sit amet',
							'template_id' => '1',
							'is_active' => true,
							'created' => '2015-07-09 14:18:46',
							'modified' => '2015-07-09 14:18:46'
						)
					)
				)
			),
			array(
				'Product' => array(
					'id' => '1',
					'name' => 'My Product 1',
					'description' => 'Lorem ipsum dolor sit amet, aliquet feugiat. Convallis morbi fringilla gravida, phasellus feugiat dapibus velit nunc, pulvinar eget sollicitudin venenatis cum nullam, vivamus ut a sed, mollitia lectus. Nulla vestibulum massa neque ut et, id hendrerit sit, feugiat in taciti enim proin nibh, tempor dignissim, rhoncus duis vestibulum nunc mattis convallis.',
					'brand_id' => '2',
					'tax_level_id' => '1',
					'template_id' => '1',
					'is_active' => true,
					'is_featured' => false,
					'created' => '2015-07-09 14:20:55',
					'modified' => '2015-07-09 14:20:55'
				),
				'Variant' => array(
					array(
						'id' => '2',
						'product_id' => '1',
						'name' => 'Blue Matte',
						'sku' => 'Lorem ipsum dolor sit amet',
						'rrp' => '0.000000',
						'price' => '0.000000',
						'sale_price' => '0.000000',
						'sequence' => '1',
						'is_active' => true,
						'created' => '2015-07-09 14:25:34',
						'modified' => '2015-07-09 14:25:34'
					),
					array(
						'id' => '1',
						'product_id' => '1',
						'name' => 'Red Matte',
						'sku' => 'Lorem ipsum dolor sit amet',
						'rrp' => '0.000000',
						'price' => '0.000000',
						'sale_price' => '0.000000',
						'sequence' => '2',
						'is_active' => true,
						'created' => '2015-07-09 14:25:34',
						'modified' => '2015-07-09 14:25:34'
					)
				),
				'ListingImage' => array(),
				'CategoriesProduct' => array(
					array(
						'id' => 1,
						'category_id' => 1,
						'product_id' => 1,
						'sequence' => 10,
						'Category' => array(
							'id' => '1',
							'parent_id' => '0',
							'lft' => '1',
							'rght' => '2',
							'name' => 'Category 1',
							'body' => 'Lorem ipsum dolor sit amet',
							'template_id' => '1',
							'is_active' => true,
							'created' => '2015-07-09 14:18:46',
							'modified' => '2015-07-09 14:18:46'
						)
					)
				)
			)
		);

		$this->assertEquals(
			$expected,
			$this->ProductsComponent->listingByCategory(array(1, 2))

		);
	}

	public function testListingByBrandReturnsTheProductDataWhenGivenOneBrandId() {
		$expected = array(
			array(
				'Product' => array(
					'id' => '2',
					'name' => 'My Product 2',
					'description' => 'Second product',
					'brand_id' => '1',
					'tax_level_id' => '1',
					'template_id' => '1',
					'is_active' => true,
					'is_featured' => true,
					'created' => '2015-07-09 14:20:55',
					'modified' => '2015-07-09 14:20:55'
				),
				'Variant' => array(
					array(
						'id' => '3',
						'product_id' => '2',
						'name' => 'My Product 2',
						'sku' => 'qweqweqwe',
						'rrp' => '0.000000',
						'price' => '0.000000',
						'sale_price' => '0.000000',
						'sequence' => '1',
						'is_active' => true,
						'created' => '2015-07-09 14:25:34',
						'modified' => '2015-07-09 14:25:34'
					)
				),
				'ListingImage' => array()
			)
		);

		$this->assertEquals(
			$expected,
			$this->ProductsComponent->listingByBrand(1)

		);
	}

	public function testListingByBrandReturnsTheProductDataWhenGivenMultipleBrandId() {
		$expected = array(
			array(
				'Product' => array(
					'id' => '2',
					'name' => 'My Product 2',
					'description' => 'Second product',
					'brand_id' => '1',
					'tax_level_id' => '1',
					'template_id' => '1',
					'is_active' => true,
					'is_featured' => true,
					'created' => '2015-07-09 14:20:55',
					'modified' => '2015-07-09 14:20:55'
				),
				'Variant' => array(
					array(
						'id' => '3',
						'product_id' => '2',
						'name' => 'My Product 2',
						'sku' => 'qweqweqwe',
						'rrp' => '0.000000',
						'price' => '0.000000',
						'sale_price' => '0.000000',
						'sequence' => '1',
						'is_active' => true,
						'created' => '2015-07-09 14:25:34',
						'modified' => '2015-07-09 14:25:34'
					)
				),
				'ListingImage' => array(),
				'Brand' => array(
					'id' => 1,
					'name' => 'My Brand 1',
					'body' => 'Lorem ipsum dolor sit amet, aliquet feugiat. Convallis morbi fringilla gravida, phasellus feugiat dapibus velit nunc, pulvinar eget sollicitudin venenatis cum nullam, vivamus ut a sed, mollitia lectus. Nulla vestibulum massa neque ut et, id hendrerit sit, feugiat in taciti enim proin nibh, tempor dignissim, rhoncus duis vestibulum nunc mattis convallis.',
					'sequence' => '1',
					'is_active' => true,
					'template_id' => '1',
					'created' => '2015-07-09 14:17:49',
					'modified' => '2015-07-09 14:17:49'
				)
			),
			array(
				'Product' => array(
					'id' => '1',
					'name' => 'My Product 1',
					'description' => 'Lorem ipsum dolor sit amet, aliquet feugiat. Convallis morbi fringilla gravida, phasellus feugiat dapibus velit nunc, pulvinar eget sollicitudin venenatis cum nullam, vivamus ut a sed, mollitia lectus. Nulla vestibulum massa neque ut et, id hendrerit sit, feugiat in taciti enim proin nibh, tempor dignissim, rhoncus duis vestibulum nunc mattis convallis.',
					'brand_id' => '2',
					'tax_level_id' => '1',
					'template_id' => '1',
					'is_active' => true,
					'is_featured' => false,
					'created' => '2015-07-09 14:20:55',
					'modified' => '2015-07-09 14:20:55'
				),
				'Variant' => array(
					array(
						'id' => '2',
						'product_id' => '1',
						'name' => 'Blue Matte',
						'sku' => 'Lorem ipsum dolor sit amet',
						'rrp' => '0.000000',
						'price' => '0.000000',
						'sale_price' => '0.000000',
						'sequence' => '1',
						'is_active' => true,
						'created' => '2015-07-09 14:25:34',
						'modified' => '2015-07-09 14:25:34'
					),
					array(
						'id' => '1',
						'product_id' => '1',
						'name' => 'Red Matte',
						'sku' => 'Lorem ipsum dolor sit amet',
						'rrp' => '0.000000',
						'price' => '0.000000',
						'sale_price' => '0.000000',
						'sequence' => '2',
						'is_active' => true,
						'created' => '2015-07-09 14:25:34',
						'modified' => '2015-07-09 14:25:34'
					)
				),
				'ListingImage' => array(),
				'Brand' => array(
					'id' => 2,
					'name' => 'My Brand 2',
					'body' => 'Lorem ipsum dolor sit amet, aliquet feugiat. Convallis morbi fringilla gravida, phasellus feugiat dapibus velit nunc, pulvinar eget sollicitudin venenatis cum nullam, vivamus ut a sed, mollitia lectus. Nulla vestibulum massa neque ut et, id hendrerit sit, feugiat in taciti enim proin nibh, tempor dignissim, rhoncus duis vestibulum nunc mattis convallis.',
					'sequence' => '2',
					'is_active' => true,
					'template_id' => '1',
					'created' => '2015-07-09 14:17:49',
					'modified' => '2015-07-09 14:17:49'
				)
			)
		);

		$this->assertEquals(
			$expected,
			$this->ProductsComponent->listingByBrand(array(1, 2))

		);
	}
}
