<?php
App::uses('AppController', 'Controller');
App::uses('CakeRequest', 'Network');
App::uses('CakeResponse', 'Network');
App::uses('ComponentCollection', 'Controller');
App::uses('CategoriesComponent', 'EvShop.Controller/Component');

// A fake controller to test against
class CategoriesControllerTest extends AppController {

}


class CategoriesComponentTest extends CakeTestCase {

	public $ProductsComponent = null;

	public $Controller = null;

	/**
	 * Fixtures
	 *
	 * @var array
	 */
	public $fixtures = array(
		'plugin.EvCore.image',
		'plugin.EvCustomFields.fields',
		'plugin.EvCustomFields.field_data',
		'plugin.MetaData.meta_data',
		'plugin.EvShop.product',
		'plugin.EvShop.brand',
		'plugin.EvShop.variant',
		'plugin.EvShop.category',
		'plugin.EvShop.categories_product'
	);

	/**
	 * setUp method
	 *
	 * @return void
	 */
	public function setUp() {
		parent::setUp();
		// Setup our component and fake test controller
		$Collection = new ComponentCollection();
		$this->CategoriesComponent = new CategoriesComponent($Collection);
		$CakeRequest = new CakeRequest();
		$CakeResponse = new CakeResponse();
		$this->Controller = new CategoriesControllerTest($CakeRequest, $CakeResponse);
		$this->Controller->constructClasses();

		$this->CategoriesComponent->initialize($this->Controller);
	}

	/**
	 * tearDown method
	 *
	 * @return void
	 */
	public function tearDown() {
		parent::tearDown();
		// Clean up after we're done
		unset($this->CategoriesComponent);
		unset($this->Controller);
	}

	public function testListingReturnsAllActiveCategoriesAndDataWithNoParamsPassedAndWhenPagingDisabled() {
		$expected = array(
			array(
				'Category' => array(
					'id' => '1',
					'parent_id' => 0,
					'lft' => '1',
					'rght' => '2',
					'name' => 'Category 1',
					'body' => 'Lorem ipsum dolor sit amet',
					'template_id' => '1',
					'is_active' => true,
					'created' => '2015-07-09 14:18:46',
					'modified' => '2015-07-09 14:18:46'
				),
				'ListingImage' => array()
			),
			array(
				'Category' => array(
					'id' => '3',
					'parent_id' => 0,
					'lft' => '3',
					'rght' => '6',
					'name' => 'Category 3',
					'body' => 'Lorem ipsum dolor sit amet',
					'template_id' => '1',
					'is_active' => true,
					'created' => '2015-07-09 14:18:46',
					'modified' => '2015-07-09 14:18:46'
				),
				'ListingImage' => array()
			),
			array(
				'Category' => array(
					'id' => '2',
					'parent_id' => 0,
					'lft' => '7',
					'rght' => '8',
					'name' => 'Category 2',
					'body' => 'Lorem ipsum dolor sit amet',
					'template_id' => '1',
					'is_active' => true,
					'created' => '2015-07-09 14:18:46',
					'modified' => '2015-07-09 14:18:46'
				),
				'ListingImage' => array()
			)
		);

		$this->assertEquals(
			$expected,
			$this->CategoriesComponent->listing()
		);

		$this->assertEquals(
			$expected,
			$this->CategoriesComponent->listing(array(), false)
		);
	}

	public function testListingByParentReturnsSubCategoriesAndData() {
		$expected = array(
			array(
				'Category' => array(
					'id' => '4',
					'parent_id' => 3,
					'lft' => '4',
					'rght' => '5',
					'name' => 'Category 3 Sub Category 1',
					'body' => 'Lorem ipsum dolor sit amet',
					'template_id' => '1',
					'is_active' => true,
					'created' => '2015-07-09 14:18:46',
					'modified' => '2015-07-09 14:18:46'
				),
				'ListingImage' => array()
			)
		);

		$this->assertEquals(
			$expected,
			$this->CategoriesComponent->listingByParent(3)
		);
	}

}
