<?php

App::uses('Image', 'EvCore.Model');

class VariantImage extends Image {

	public $useTable = 'images'; // Don't set a table prefix here

	public $alias = 'VariantImage'; // The following two options should match

	public $name = 'VariantImage';

	public $hasMany = [
		'VariantImageOption' => [
			'className' => 'EvShop.VariantImageOption'
		]
	];

	public function afterFind($results, $primary = false) {
		$results = parent::afterFind($results, $primary);

		//Find variant image options if it has any (is_restricted = true) and add them to the results
		foreach ($results as $resultKey => $variantImage) {
			foreach ($variantImage as $imageType => $image) {
				//Only get the options if the image is restricted to a variant.
				// if (isset($image['is_restricted']) && $image['is_restricted']) {
					$imageId = $image['id'];

					$imageOptions = $this->VariantImageOption->find('all', [
						'conditions' => [
							'VariantImageOption.image_id' => $imageId
						]
					]);

					if (!empty($imageOptions)) {
						foreach ($imageOptions as $imageOption) {
							$results[$resultKey][$imageType]['VariantImageOption'][] = $imageOption['VariantImageOption'];
						}

					}
				// }
			}
		}

		return $results;
	}

	public function processVariantImageOptions($data, $imageSlots) {
		//For every image in every image slot
		if (is_array($imageSlots)) {
			foreach (array_keys($imageSlots) as $slotName) {
				$slotNameFull = Inflector::camelize($slotName) . $this->alias;

				if (!empty($data[$slotNameFull])) {
					foreach ($data[$slotNameFull] as $imageKey => $image) {
						//First delete all image options
						$this->VariantImageOption->deleteAll(
							[
								'VariantImageOption.image_id' => $image['id']
							]
						);

						//Create an image option for each option in option group
						if (isset($image['is_restricted']) && $image['is_restricted']) {
							$data[$slotNameFull][$imageKey]['VariantImageOption'] = $this->_restructureVariantImageOptions($image['VariantImageOption']);
						} else {
							unset($data[$slotNameFull][$imageKey]['VariantImageOption']);
						}
					}
				}
			}
		}

		return $data;
	}

	protected function _restructureVariantImageOptions($variantImageOptions) {
		$newVariantImageOptions = [];

		foreach ($variantImageOptions as $variantImageOption) {
			if (!empty($variantImageOption['options'])) {
				$optionGroupId = $variantImageOption['option_group_id'];

				foreach ($variantImageOption['options'] as $option) {
					$newVariantImageOptions[] = [
						'option_group_id' => $optionGroupId,
						'option_id' => $option
					];
				}
			}
		}

		return $newVariantImageOptions;
	}
}
