<?php
App::uses('EvShopAppModel', 'EvShop.Model');
/**
 * Option Model
 *
 * @property OptionGroup $OptionGroup
 * @property Variant $Variant
 */
class Option extends EvShopAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'option_group_id' => array(
			'notEmpty' => array(
				'rule' => array('notBlank'),
				'message' => 'Please select an option group'
			),
		),
		'name' => array(
			'notEmpty' => array(
				'rule' => array('notBlank'),
				'message' => 'An option name must be entered'
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'OptionGroup' => array(
			'className' => 'EvShop.OptionGroup'
		)
	);

/**
 * hasAndBelongsToMany associations
 *
 * @var array
 */
	public $hasAndBelongsToMany = array(
		'Variant' => array(
			'className' => 'EvShop.Variant',
			'joinTable' => 'ev_shop_options_variants'
		)
	);

/**
 * Constructor. Binds the model's database table to the object.
 *
 * @param bool|int|string|array $id Set this ID for this model on startup,
 * can also be an array of options, see above.
 * @param string $table Name of database table to use.
 * @param string $ds DataSource connection name.
 */
	public function __construct($id = false, $table = null, $ds = null) {
		if (! empty(Configure::read('EvShop.manageOptions'))) {
			// update the model image slots
			$this->imageSlots = [
				'main' => [
					'fields' => false,
					'slots' => 1
				]
			];
		}

		parent::__construct($id, $table, $ds);
	}

	/**
	 * get the given options name data
	 *
	 * @param 	array 	array of option IDs
	 * @return 	array 	array list of all options in id => name format
	 */
	public function getOptionNames($options) {
		return $this->find(
			'list',
			array(
				'conditions' => array(
					'Option.id' => $options
				),
				'callbacks' => false
			)
		);
	}

/**
 * Retuns array of options for the product edit admin template
 * based on the supplied product id and its tagged variants
 *
 * @param int $productId The unique id of the product
 * @return array Contains the options for the product grouped by option group id
 */
	public function readForProductEdit($productId = null) {
		$data = [];

		if (! empty($productId)) {
			// retreive all variant ids for the product
			$variantIds = $this->Variant->find('list', [
				'conditions' => [
					'Variant.product_id' => $productId
				],
				'fields' => [
					'Variant.id',
					'Variant.id'
				]
			]);

			// read all options for the variant ids
			$optionsData = $this->find('all', [
				'joins' => [
					[
						'table' => 'ev_shop_options_variants',
						'alias' => 'OptionsVariant',
						'type' => 'INNER',
						'conditions' => [
							'OptionsVariant.option_id = Option.id',
							'OptionsVariant.variant_id' => $variantIds
						]
					]
				]
			]);

			$data = Hash::combine(
				$optionsData,
				'{n}.Option.id',
				'{n}.Option.id',
				'{n}.Option.option_group_id'
			);
		}

		return $data;
	}
}
