<?php

App::uses('AppModel', 'Model');

class EvShopAppModel extends AppModel {

	//Prefix with name of plugin to stop conflicts
	public $tablePrefix = "ev_shop_";

	public $variantImageSlots = 0;

	// Optionally disable caching of certain models
	public $disableCache = array();

	/**
	 * Initialises the associated models such as Image, Document and Block
	 */
	public function initialiseAssociateModels() {
		// Set up model associations for images automagically based on the
		// image slots.
		$this->_associateModels('EvShop.VariantImage', $this->variantImageSlots);

		parent::initialiseAssociateModels();
	}

	/**
	 * Base code for retrieving a single record for edit or view
	 *
	 * @param integer $id ID of row to edit
	 * @param array $query The db query array - can be used to pass in additional parameters such as contain
	 * @return array
	 */
	protected function _getItem($id, $query = array()) {
		$query = array_merge_recursive($query, $this->_containAssociateModel('VariantImage', $this->variantImageSlots));

		$data = parent::_getItem($id, $query);

		return $data;
	}

	public function find($type = 'first', $query = array()) {

		if (Configure::read('EvShop.enableRedis') == true && extension_loaded('redis')) {
			$group = $this->getCacheGroup();

			$cacheName = $this->_getCacheName($type, $query);

			if (! in_array($this->alias, $this->disableCache)) {
				$result = Cache::read($cacheName, $group);
				if (! empty($result)) {
					return $result;
				} else {
					$result = parent::find($type, $query);
					Cache::write($cacheName, $result, $group);

					return $result;
				}
			}
		}

		return parent::find($type, $query);
	}

	public function afterSave($created, $options = array()) {
		if (Configure::read('EvShop.enableRedis') == true && extension_loaded('redis')) {
			$this->clearCache();
		}

		return parent::afterSave($created, $options);
	}

	public function getCacheGroup() {
		$prefix = Configure::read('App.fullBaseUrl');

		Cache::config($prefix . $this->alias, array(
			'engine' => 'Redis',
			'duration' => '+999 days',
			'groups' => array($prefix . $this->alias)
		));

		return $prefix . $this->alias;
	}

	public function clearCache() {
		$redis = new Redis();
		$redis->connect('127.0.0.1', '6379', 0);
		$keys = $redis->getKeys(Inflector::slug(APP_DIR) . '_*');
		$redis->delete($keys);
		$redis->close();

		Cache::clearGroup($this->getCacheGroup());
		Cache::clear();
	}

	protected function _getCacheName($type, $query) {
		return md5($type . json_encode($query));
	}

}
