<?php

App::uses('CakeEventListener', 'Event');
App::uses('DiscountLib', 'EvDiscount.Lib');

class EvShopCheckForDiscountRestrictionsListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvBasket.Component.BasketItem.CheckDiscountRestrictions' => 'checkForDiscountRestrictions',
		);
	}

	/**
	 * rebuild discount due to basket amends
	 *
	 * @param 	CakeEvent
	 */
	public function checkForDiscountRestrictions(CakeEvent $Event) {
		$result = array();

		if (isset($Event->data['discount']['code_restrictions'])
			&& ! empty($Event->data['discount']['code_restrictions'])
			&& isset($Event->data['basket_item'])
			&& ! empty($Event->data['basket_item'])) {

			// Restrictions were found. Check to see if they are for the shop
			$basketItem = $Event->data['basket_item'];
			$discount = $Event->data['discount'];

			// Get the product id for basket item
			if ($basketItem['model'] == 'EvShop.Variant') {
				if (isset($basketItem['Variant']['Product'])) {
					$productId = $basketItem['Variant']['Product']['id'];
				}
			} elseif ($basketItem['model'] == 'EvShop.Product') {
				$productId = $basketItem['model_id'];
			}

			// Default to invalidating the discount
			$result = array(
				'discountValue' => false
			);

			// We've now got a list of product ids in the basket. Now we need to go through each code restriction
			// and work out if it applies to any of the products in the basket.
			foreach ($discount['code_restrictions'] as $restriction) {
				if ($restriction['model'] == 'EvShop.Product') {
					if ($productId === $restriction['model_id']) {
						// It's a match - we allow the product to be discounted.
						$result = array(
							'discountValue' => true
						);
					}
				} elseif ($restriction['model'] == 'EvShop.Brand') {
					// Check if the brand applies to any of the products
					if (isset($basketItem['Variant']['Product']['brand_id'])
						&& $basketItem['Variant']['Product']['brand_id'] > 0) {

						if ($basketItem['Variant']['Product']['brand_id'] == $restriction['model_id']) {
							// It's a match - we allow the product to be discounted.
							$result = array(
								'discountValue' => true
							);
						}
					} elseif (isset($basket['BasketItem']['Product']['brand_id']) && $basket['BasketItem']['Product']['brand_id']) {

						if ($basket['BasketItem']['Product']['brand_id'] == $restriction['model_id']) {
							// It's a match - we allow the product to be discounted.
							$result = array(
								'discountValue' => true
							);
						}
					}
				} elseif ($restriction['model'] == 'EvShop.Category') {
					// Load the category records associated with this product id
					$categoryProductModel = EvClassRegistry::init('EvShopCategoriesProducts');
					$categoryProducts = $categoryProductModel->find('list', array(
						'fields' => array('category_id'),
						'conditions' => array(
							'product_id' => $productId
						)
					));

					if (in_array($restriction['model_id'], $categoryProducts)) {

						$price = $basket['BasketItem'][$basketItemKey]['unit_price'];
						$updatedItem = $basket['BasketItem'][$basketItemKey];

						$result = array(
							'discountValue' => true
						);
					}
				}
			}

			return $result;
		}
		return array();
	}
}
