<?php

App::uses('ImagesController', 'EvCore.Controller');

class VariantImagesController extends ImagesController {

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array('ajax_displayNew'));

		return;
	}

	/**
 	* Add a new image slot via AJAX.
 	*
 	* @param string $model The model to link the image to e.g. Page
 	* @param integer $key Image slot number
 	* @param string $type
 	* @param string $prefix Used when embedding images multiple levels deep e.g. Hotel.Room.0.Image
 	* @param string $plugin
 	* @param string $fields 	Comma separated list of fields
 	*/
	public function ajax_add($model, $key = 0, $type = 'Image', $prefix = "", $plugin = "", $itemFields = "") {
		$slotType = str_replace("VariantImage", "", $type);

		if ($prefix == "" || $prefix == "false") {
			$prefix = $slotType;
		}

		if ($slotType == "") {
			$slotType = 'main';
		}

		if (! empty($plugin) && $plugin !== 'false') {
			$this->loadModel($plugin . "." . $model);
		} else {
			$this->loadModel($model);
		}

		$fields = false;
		if (! empty($itemFields) && $itemFields !== "false") {

			$fields = explode(',', $itemFields);
		} else {
			if (
				isset($this->$model->imageSlots[Inflector::underscore($slotType)])
			) {
				if (
					is_array($this->$model->imageSlots[Inflector::underscore($slotType)])
					&& array_key_exists('fields', $this->$model->imageSlots[Inflector::underscore($slotType)])
				) {
					$fields = $this->$model->imageSlots[Inflector::underscore($slotType)]['fields'];
				} elseif (
					! is_array($this->$model->imageSlots[Inflector::underscore($slotType)])
					&& ! empty($this->$model->imageSlots[Inflector::underscore($slotType)])
				) {
					$fields = $this->$model->imageSlots[Inflector::underscore($slotType)];
				}
			}
		}

		if (isset($this->{$model}->imageSlots[Inflector::underscore($slotType)]['fields']) && is_array($fields)) {
			$availableFields = $this->{$model}->imageSlots[Inflector::underscore($slotType)]['fields'];
			// Check the model to see if any of the fields have custom field settings defined.
			foreach ($fields as $fieldKey => $field) {

				if (isset($availableFields[$field]) && is_array($availableFields[$field])) {
					unset($fields[$fieldKey]);
					$fields[$field] = $availableFields[$field];

				}
			}
		}

		//Set product options
		$this->set('options', []);

		$this->set(compact('model', 'prefix', 'key', 'type', 'fields'));
		$this->theme = "Admin";
		$this->render('EvShop.ajax_add', 'ajax');

		return;
	}

	public function ajax_displayNew($filename, $fileId, $sash) {
		$this->set('imageFilename', $filename);
		$this->set('imageFileId', $fileId);
		$this->set('imageSash', $sash);

		$this->render('EvShop.ajax_display_new', 'ajax');
	}
}
