<?php

App::uses('EvShopAppController', 'EvShop.Controller');

class OptionsController extends EvShopAppController {

	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();

		$Model = $this->{$this->modelClass};

		// find and assign list of available option groups
		$this->set(
			'optionGroups',
			$Model->OptionGroup->find('list', [
				'order' => 'OptionGroup.name ASC'
			])
		);
	}

/**
 * Defines the buttons in the toolbar displayed on an admin_form
 *
 * Override in your controller to customise
 *
 * @param integer $id
 * @return array
 */
	protected function _adminFormToolbar($id = null) {
		$formToolbar = parent::_adminFormToolbar($id);

		if (! empty($id)) {
			// fetch the option group id, based on the current items id that will
			// allow us to include a link back to the option group template
			$optionGroupId = $this->{$this->modelClass}->fieldOnly('option_group_id', [
				'id' => $id
			]);

			// add link open up navigation back to the option group template
			$formToolbar['Return to Option Group'] = [
				'class' => 'toolbar__btn--listing',
				'url' => [
					'admin' => true,
					'plugin' => 'ev_shop',
					'controller' => 'option_groups',
					'action' => 'edit',
					$optionGroupId
				]
			];
		}

		return $formToolbar;
	}

}
