<?php

App::uses('AppComponent', 'Controller/Component');

class CategoriesComponent extends AppComponent {

	/**
	 * get a Category listing
	 *
	 * @param 	array 	query / paginate params
	 * @param 	bool 	Paginate results or not?
	 * @return 	array 	Array of results
	 */
	public function listing($params = array(), $paginate = true) {
		$params = Hash::merge(
			array(
				'conditions' => array(
					'Category.is_active' => 1,
					'Category.parent_id' => null
				),
				'order' => 'Category.lft ASC, Category.name ASC',
				'contain' => array(
					'ListingImage'
				)
			),
			$params
		);

		$Category = EvClassRegistry::init('EvShop.Category');

		if ($paginate && ! empty($this->_controller)) {
			$this->_controller->Paginator->settings = $params;
			return $this->_controller->Paginator->paginate(
				$Category
			);
		} else {
			return $Category->find('all', $params);
		}
	}

	/**
	 * get a Category listing by parent id
	 *
	 * @param 	int 	The parent ID
	 * @param 	array 	query / paginate params
	 * @param 	bool 	Paginate results or not?
	 * @return 	array 	Array of results
	 */
	public function listingByParent($parentId, $params = array(), $paginate = true) {
		$defaults = array(
			'conditions' => array(
				'Category.parent_id' => $parentId
			)
		);

		$params = Hash::merge(
			$defaults,
			$params
		);

		return $this->listing($params, $paginate);
	}

	/**
	 * run the form injection
	 * For custom fields this add type / validation arrays to the template for fields
	 *
	 * @param   array       Data from $this->request->data
	 * @param   object      Model Object for the primary model we are dealing with
	 * @param   int|null    The ID if on edit or null of add
	 */
	public function injectAdminForm($data, $Model, $id) {
		$Category = EvClassRegistry::init('EvShop.Category');

		$this->_controller->set(
			'categories',
			$Category->generateTreeList(
				null,
				null,
				null,
				'--'
			)
		);
	}
}