<?php
App::uses('EvShopAppController', 'EvShop.Controller');

class BrandsController extends EvShopAppController {

	protected function _adminFilterFields() {
		$fields = parent::_adminFilterFields();

		unset(
			$fields['Brand.id'],
			$fields['Brand.created'],
			$fields['Brand.modified']
		);

		return $fields;
	}

	/**
	 * redefine to allow the index / view page through the auth component!
	 */
	public function beforeFilter() {
		if (! Configure::read('EvShop.showBrands')) {
			throw new NotFoundException();
		}

		parent::beforeFilter();

		$this->Auth->allow(array('index', 'view'));
	}

	/**
	 * process the param array for brands
	 *
	 * @return 	array 		   	  Standard parameter array to pass to find
	 */
	protected function _processBrandParams() {
		return array();
	}

	/**
	 * process the param array for products
	 *
	 * @param 	array 	$Brand The parent Brand
	 * @return 	array 		   	  Standard parameter array to pass to find
	 */
	protected function _processProductParams($Brand) {
		return array();
	}

	/**
	 * brands index page
	 * list all brands out
	 *
	 */
	public function index() {
		$this->view = 'EvShop./Fallbacks/Brands/index';
		$pageId = Configure::read('EvShop.pageIds.brand');

		// check if we have a specific content page set
		// if so - set the template
		if (! empty($pageId)) {
			$pageData = $this->assignPage($pageId);

			if (! empty($pageData)) {
				$this->view = $this->Tpl->getTemplate($pageData, 'Page');
			}
		}

		$this->set(
			'listing',
			$this->Brands->listing(
				$this->_processBrandParams()
			)
		);

		$this->Breadcrumb->addCrumb(__('Brands'));
	}

	/**
	 * brand view details page
	 *
	 * @param 	int 	Brand ID
	 */
	public function view($id) {
		$this->view = 'EvShop./Fallbacks/Brands/view';
		$Model = $this->{$this->modelClass};

		$data = $Model->readForView($id);
		if (empty($data)) {
			throw new NotFoundException();
		}

		$this->set('data', $data);
		$this->Meta->set($data);

		if (! empty($data[$Model->alias]['template_id'])) {
			$this->view = $this->Tpl->getTemplate($data);
		}

		$this->set(
			'productListing',
			$this->Products->listingByBrand(
				$id,
				$this->_processProductParams($data)
			)
		);

		$this->Breadcrumb->addCrumb(
			__('Brands'),
			$this->Routable->getListingRoute('EvShop', 'Brand')
		);

		$this->Breadcrumb->addCrumb(
			$data['Brand']['name']
		);
	}

	/**
	 * form fields - check for EvTax and auto remove
	 * check for brands setting and auto remove
	 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['Brand.body']['type'] = 'html';

		return $fields;
	}
}
