<?php

App::uses('AppShell', 'Console/Command');

App::uses('VariantPricing', 'EvShop.Model');
App::uses('Currency', 'EvCurrency.Model');

class UpdatePricingShell extends AppShell {

	/**
	 * used to update the pricing rates by forcing a save on the variant pricing records for the
	 * default currency.
	 */
	public function update() {
		$Currency = EvClassRegistry::init('EvCurrency.Currency');
		$defaultCurrency = $Currency->find('first', array(
			'conditions' => array(
				'is_default' => 1
			)
		));

		if (empty($defaultCurrency)) {
			die('No default currency set');
		}

		$VariantPricing = EvClassRegistry::init('EvShop.VariantPricing');
		$pricingData = $VariantPricing->find('all', array(
			'conditions' => array(
				'currency_id' => $defaultCurrency['Currency']['id']
			)
		));
		$pricingRecords = array();

		if (! empty($pricingData)) {
			foreach ($pricingData as $price) {
				if (isset($price[0]['VariantPricing']['variant_id']) && $price[0]['VariantPricing']['variant_id'] > 0) {
					$pricingRecords[] = $VariantPricing->updateLowestPrice($price[0])['VariantPricing'];
				}
			}
		}

		$VariantPricing->clear();
		$result = $VariantPricing->saveAll($pricingRecords, array('deep' => false));

		if ($result) {
			$this->out('lowest_price field has been updated for all variants.');
		} else {
			$this->out('<error>Failed to update lowest_price field.</error>');
		}
	}
}
