<?php

/**
 * brands index page
 */
Router::connect('/brands/*', array(
	'plugin' => 'ev_shop',
	'controller' => 'brands',
	'action' => 'index'
));

/**
 * categories index page
 */
Router::connect('/categories/*', array(
	'plugin' => 'ev_shop',
	'controller' => 'categories',
	'action' => 'index'
));


/**
 * view all products index page
 */
Router::connect('/products/*', array(
	'plugin' => 'ev_shop',
	'controller' => 'products',
	'action' => 'index'
));

/**
 * google product feed
 */
Router::setExtensions('xml', true);
Router::parseExtensions();

Router::connect('/google-product-feed', array(
	'plugin' => 'ev_shop',
	'controller' => 'google_feed',
	'action' => 'index'
));

/*
 * Routes for variant images
 */
Router::connect('/ajax/variantImages/:action/*', array(
	'plugin' => 'ev_shop',
	'controller' => 'variant_images',
	'ajax' => true
));
