<?php
class UpdatedEvshopToBeMulticurrencyAsStandard extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'updated_evshop_to_be_multicurrency_as_standard';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'drop_field' => array(
				'ev_shop_products' => array('tax_level_id', 'indexes' => array('fk_products_tax_levels1_idx')),
				'ev_shop_variants' => array('rrp', 'price', 'sale_price'),
			),
			'create_table' => array(
				'ev_shop_variant_pricings' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'primary'),
					'variant_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'rrp' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
					'price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
					'sale_price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
					'trade_price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
					'currency_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'tax_level_id' => array('type' => 'integer', 'null' => true, 'default' => '0', 'unsigned' => false),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'updated' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_general_ci', 'engine' => 'InnoDB'),
				),
			),
		),
		'down' => array(
			'create_field' => array(
				'ev_shop_products' => array(
					'tax_level_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
					'indexes' => array(
						'fk_products_tax_levels1_idx' => array('column' => 'tax_level_id', 'unique' => 0),
					),
				),
				'ev_shop_variants' => array(
					'rrp' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
					'price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
					'sale_price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
				),
			),
			'drop_table' => array(
				'ev_shop_variant_pricings'
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
