<?php
class ChangedTaxidAndBrandidToAllowNullAndAddedIsActiveToVariants extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'Changed_taxid_and_brandid_to_allow_null_and_added_is_active_to_variants';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'alter_field' => array(
				'ev_shop_products' => array(
					'brand_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
					'tax_level_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
				),
			),
			'create_field' => array(
				'ev_shop_variants' => array(
					'is_active' => array('type' => 'boolean', 'null' => true, 'default' => '0', 'after' => 'sale_price'),
				),
			),
		),
		'down' => array(
			'alter_field' => array(
				'ev_shop_products' => array(
					'brand_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
					'tax_level_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
				),
			),
			'drop_field' => array(
				'ev_shop_variants' => array('is_active'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
