# EvShop

## Installation

Simply add EvShop to the `install.php` file within the Config directory and run `Console/cake installer core` once you have added all the other plugins you will need.

If this has already been run, simply run `Console/cake installer plugin EvShop`.

The installer will automatically setup the database tables, add all the needed menu links to the admin, create the templates needed to display the pages and finally create the pages needed for the brands / category / products listing screens and automatically create and save the `ev_shop` config.

## How it works

### Shop Core

The bulk of the shop is handled via the brands, categories and products components which are used to retrieve the paginated listing of each section. The standard shop format is setup within the bundled controllers but using these components will allow you to add listings to other sections of a site.

All pages also run using the template system, basic templates for all of these are bundled with the plugin that should show all the available variables. If for some reason a template doesn't exist the shop will fallback and use a more basic "fallback template" also bundled with the plugin.

### Option Groups / Options

Option groups and options work on a global basis in that they are added separately from products. Products then simply retrieve the full list of options ready for the user to select. Simply means that alot of work can be cut down for a user as they won't have to manually enter options for every product. 

Options are also not directly tied to a product, options only ever get tagged to a variant so we can keep a check of which options make up each variant.

### Variants

To help keep the code simple, variants are always used regardless of whether any options are ticked for the product or whether they are disabled or not. 

Doing this allows us to keep the plugin simple, it means that each product will always have a least 1 variant.

If it's from a product that was tagged to options, these options will then also be tagged to the variant so that we may identify which options each variant is made up of.

### Variant Rebuilding

The system attempts to be clever with when it rebuilds the variants as in doing so, **it may cause you to lose SKU / Pricing data**. To help minimise the risk of losing data the system tries to detect when an option from an option group has been added or removed before rebuilding.

e.g. If we previously had selected Colour group options of Red and Blue and Size group options of Regular and Large we would have 4 variants created 

* Red Regular
* Red Large
* Blue Regular
* Blue Large

Upon selecting another colour, we simply need to create another 2 variants linking the new colour to each size so the existing variants are left as they are.

Whereas adding 2 options of Wood and Metal from the Type option group would require the rebuilding of all the current options as there is no longer `Red Regular` as we have now `Red Regular Wood` and `Red Regular Metal`.

Similarly, if the two Type options were removed, we would have to rebuild all variants again as `Red Regular Wood` and `Red Regular Metal` would no longer be options.

## Setup

Setup is relatively simple for a standard E-Commerce setup. As default, Variants and brands are active and all that will need setting overriding in the config are the ID numbers for the brand, category, product listing pages. This is so on the main landing page for each of those section SEO meta data can be applied. This should however be handled by the installer as mentioned above.

## Extending / Using

### Default Setup

As default, the shop plugin will automatically build up a breadcrumb trail and assign to the templates. Assuming `EvTax` is retrieved from composer, each product and variant will have Tax set up for usage, as well as each variant having an inventory row created within EvInventory (again if included via composer).

For full documentation on extending controllers, see the Core Documentation

### Category Controllers

In most shops, it's likely that it's the categories listing that is the main bit which will be modified. Some "stub" methods are defined within the categories controller which are used to pass array parameters to the find methods when on category / product listings as shown below.

	$this->set(
		array(
			'categoryListing' => $this->Categories->listingByParent(
				$id,
				$this->_processCategoryParams($data),
				false
			),
			'productListing' => $this->Products->listingByCategory(
				$this->categoryIds,
				$this->_processProductParams($data)
			)
		)
	);

This was used with great effect in Brighton Tools project to customise the category listing to also include a brand filter and to also amend the default ordering of products.

	protected function _processProductParams($Category) {
		$params = parent::_processProductParams($Category);

		if (! empty($this->request->params['named']['brand_id'])) {
			$params['conditions']['Product.brand_id'] = $this->request->params['named']['brand_id'];
		}

		$params['maxLimit'] = 1000000;

		$params['order'] = 'Product.created DESC, CategoriesProduct.sequence ASC, Product.name ASC';

		return $params;
	}

### Google Feed

Bundled with the plugin is a Google Feed Controller that is used to create a Google Xml product feed. This is automatically accessible via http://thesite.com/google-product-feed.xml

Unless there are specific requirements, the included setup should cover most cases where you require the feed, the only thing that needs to be done during setup is to set the Google Category for the products within the Config. The google categories can be found at <https://support.google.com/merchants/answer/1705911>. This will currently set the same Google category for each product. The internal Shop categories are set to the product at the `product_type` element where it will select the first category it returns (if multiple are selected).


## Events

### EvShop.Model.Product.saved

Called in Products afterSave callback once variants have processed.

#### Parameters

* `newItem` - contains the boolean value from afterSaves created parameter.


### EvShop.Model.Variant.saved

Called in Variant afterSave callback.

#### Parameters

* `newItem` - contains the boolean value from afterSaves created parameter.