<?php
App::uses('AppHelper', 'View/Helper');

class ProductsHelper extends AppHelper {

	/**
	 * for a product with single variant, extract the requests data
	 *
	 * @param 	string 		The column to extract
	 * @param 	array 		The Data array
	 * @return 	mixed 		The extracted data or bool false if multiple variants
	 */
	public function singleVariantData($item, $data) {
		if (count($data['Variant']) > 1) {
			return false;
		}

		return Hash::get($data, 'Variant.0.' . $item);
	}

	/**
	 * get the option groups for the variants
	 *
	 * @param  	array 	Product Data array
	 * @return 	array 	Array of option groups
	 */
	public function getOptionGroups($data) {
		if (! empty($data['Variant']['0']['Option'])) {
			return Hash::combine($data['Variant'], '{n}.Option.{n}.OptionGroup.id', '{n}.Option.{n}.OptionGroup.name');
		}

		return array();
	}

	/**
	 * given the variant array and the option group
	 * return the option name
	 *
	 * @param 	array 	Variant Array
	 * @param 	int 	Option group Id
	 * @return 	string 	Option value
	 */
	public function getOption($Variant, $groupId) {
		return Hash::get($Variant, 'Option.' . $groupId . '.name', '-');
	}
}
