<?php $variantCount = count($data['Variant']); ?>
<?php foreach ($data['Variant'] as $key => $Variant): ?>
	<?php
	$name = $data['Product']['name'];
	if ($variantCount > 1):
		$name .= ': ' . $Variant['name'];
	endif;

	if (empty($Variant['sku']) || empty($data['Brand']['name'])):
		continue;
	endif;

	$price = $Variant['price_incTax'];
	if (! empty($Variant['sale_price_incTax']) && $Variant['sale_price_incTax'] > '0.000000'):
		$price = $Variant['sale_price_incTax'];
	endif;

	$this->Html->scriptBlock(
	'{
		"@context": "http://schema.org/",
		"@type": "Product",
		"name": "' . $name. '",
		"description": "' . strip_tags($data['Product']['description']) . '",
		"mpn": "' . $Variant['sku'] . '",
		"brand": {
			"@type": "Thing",
			"name": "' . $data['Brand']['name'] . '"
		},
		"offers": {
			"@type": "Offer",
			"priceCurrency": "GBP",
			"price": "' . number_format($price, 2, '.', '') . '"
		}
	}',
	array(
		'inline' => false,
		'type' => 'application/ld+json'
	));
	?>
<?php endforeach; ?>
