<?php $optionGroups = $this->Products->getOptionGroups($data); ?>
<table class="table table-striped table-bordered">
    <thead>
        <tr>
            <th>SKU</th>

            <?php foreach ($optionGroups as $groupName): ?>
                <td class="volt"><?=$groupName?></td>
            <?php endforeach; ?>

            <th>Price</th>
            <th>Price (incVat)</th>
            <th> </th>
            <th> </th>
            <th> </th>
        </tr>
    </thead>

    <?php
        $tableCells = array();
        foreach ($data['Variant'] as $key => $Variant):

            $tableCells[$key][] = $Variant['sku'];

            foreach ($optionGroups as $groupId => $groupName):
                $tableCells[$key][] = $this->Products->getOption($Variant, $groupId);
            endforeach;

            $tableCells[$key][] = $this->Number->currency(
                $Variant['price'],
                'GBP'
            );
            $tableCells[$key][] = $this->Number->currency(
                $Variant['price_incTax'],
                'GBP'
            );

            if ($this->Inventory->allowPurchase($Variant)):
                $tableCells[$key][] = 'Add Form';
            else:
                $tableCells[$key][] = $this->Inventory->oosMessage();
            endif;


            if ($this->Inventory->showDelayedMessage($Variant)):
                $tableCells[$key][] = $this->Inventory->delayedMessage();
            else:
                $tableCells[$key][] = '';
            endif;


            if ($this->Inventory->showLowStockMessage($Variant)):
                 $tableCells[$key][] = $this->Inventory->lowStockMessage();
            else:
                $tableCells[$key][] = '';
            endif;

        endforeach;

        echo $this->Html->tableCells($tableCells);
    ?>
</table>