<?php
App::uses('OptionGroup', 'Model');

/**
 * OptionGroup Test Case
 *
 */
class OptionGroupTest extends CakeTestCase {

/**
 * Fixtures
 *
 * @var array
 */
	public $fixtures = array(
		'plugin.EvShop.option_group',
		'plugin.EvShop.option'
	);

/**
 * setUp method
 *
 * @return void
 */
	public function setUp() {
		parent::setUp();
		$this->OptionGroup = ClassRegistry::init('EvShop.OptionGroup');
	}

/**
 * tearDown method
 *
 * @return void
 */
	public function tearDown() {
		unset($this->OptionGroup);

		parent::tearDown();
	}

	public function testGetForSelectionReturnsCorrectArray() {
		$this->assertEquals(
			$this->OptionGroup->getForSelection(),
			array(
				0 => array(
					'OptionGroup' => array(
						'id' => '1',
						'name' => 'Color',
						'created' => '2015-07-09 14:19:19',
						'modified' => '2015-07-09 14:19:19'
					),
					'Option' => array(
						0 => array(
							'id' => '1',
							'option_group_id' => '1',
							'name' => 'Red',
							'sequence' => '0',
							'created' => '2015-07-09 14:20:06',
							'modified' => '2015-07-09 14:20:06'
						),
						1 => array(
							'id' => '2',
							'option_group_id' => '1',
							'name' => 'Blue',
							'sequence' => '1',
							'created' => '2015-07-09 14:20:06',
							'modified' => '2015-07-09 14:20:06'
						)
					)
				),
				1 => array(
					'OptionGroup' => array(
						'id' => '3',
						'name' => 'Finish',
						'created' => '2015-07-14 14:19:19',
						'modified' => '2015-07-14 14:19:19'
					),
					'Option' => array(
						0 => array(
							'id' => '4',
							'option_group_id' => '3',
							'name' => 'Matte',
							'sequence' => '0',
							'created' => '2015-07-09 14:20:06',
							'modified' => '2015-07-09 14:20:06'
						),
						1 => array(
							'id' => '5',
							'option_group_id' => '3',
							'name' => 'Gloss',
							'sequence' => 1,
							'created' => '2015-07-09 14:20:06',
							'modified' => '2015-07-09 14:20:06'
						)
					)
				),
				2 => array(
					'OptionGroup' => array(
						'id' => '2',
						'name' => 'Size',
						'created' => '2015-07-14 14:19:19',
						'modified' => '2015-07-14 14:19:19'
					),
					'Option' => array(
						0 => array(
							'id' => '3',
							'option_group_id' => '2',
							'name' => 'Small',
							'sequence' => '0',
							'created' => '2015-07-09 14:20:06',
							'modified' => '2015-07-09 14:20:06'
						)
					)
				)
			)
		);
	}
}
