<?php
App::uses('EvShopAppController', 'EvShop.Controller');


class VariantsController extends EvShopAppController {

	public function beforeFilter() {
		$this->adminActions[] = 'admin_manage';
		unset($this->adminActions[array_search('admin_edit', $this->adminActions)]);
		unset($this->adminActions[array_search('admin_delete', $this->adminActions)]);
		parent::beforeFilter();
	}

	protected function _adminManageToolbar($id) {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$actions = array(
			'All Products' => array(
				'url' => array(
					'controller' => 'products',
					'action' => 'index'
				),
				'class' => 'toolbar__btn--listing'
			),
			'Edit Product' => array(
				'url' => array(
					'controller' => 'products',
					'action' => 'view',
					$id
				),
				'class' => 'toolbar__btn--edit'
			)
		);

		return $actions;
	}

	protected function _adminManageFields() {
		return array(
			'Variant.id' => array(
				'type' => 'hidden'
			),
			'Variant.sequence' => array(
				'type' => 'hidden',
				'class' => 'sequence-input',
			),
			'optionDesc' => array(
				'type' => 'string',
				'displayonly' => 'displayonly'
			),
			'Variant.name' => array(
				'type' => 'string'
			),
			'Variant.sku' => array(
				'type' => 'string'
			),
			'Variant.rrp' => array(
				'type' => 'string',
				'before' => '<span class="currency">&pound;</span>',
				'label' => 'RRP',
				'displayInfo' => 'Enter prices ex. VAT'
			),
			'Variant.price' => array(
				'type' => 'string',
				'before' => '<span class="currency">&pound;</span>',
				'displayInfo' => 'Enter prices ex. VAT'
			),
			'Variant.sale_price' => array(
				'type' => 'string',
				'before' => '<span class="currency">&pound;</span>',
				'displayInfo' => 'Enter prices ex. VAT'
			),
			'Variant.is_active' => array(
				'type' => 'boolean'
			)
		);
	}

	/**
	 * just incase redirect to products index
	 */
	public function admin_index() {
		$this->redirect(
			array(
				'controller' => 'products'
			)
		);
	}

	/**
	 * display the variants management
	 * styled as just pricing rather then variants to prevent confusion
	 *
	 * @param 	int 	product id
	 */
	public function admin_manage($id) {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		if ($this->request->is('post') || $this->request->is('put')) {

			if ($Model->saveAll($this->request->data['Variants'], array('deep' => true))) {

				// save was successful
				$this->Flash->success(
					array(
						'title' => 'Save Successful',
						'description' => 'Pricing data has been saved successfully'
					)
				);

				// check whether to redirect to product listing or pricing page again
				if (isset($this->request->data['return']) && $this->request->data['return'] == 1) {

					$this->Session->write("Admin.$modelAlias.return", true);
					$return = array(
						'action' => 'manage',
						$id
					);
				} else {

					$this->Session->delete("Admin.$modelAlias.return");

					$redirect = $this->Session->read("Admin.$modelAlias.filter");
					if (strpos($redirect, 'Filter') !== false) {
						$return = $redirect;
					} else {
						if (in_array('EvShopProducts', App::objects('Controller'))) {
							$return = array(
								'plugin' => false,
								'controller' => 'ev_shop_proucts',
							);
						} else {
							$return = array(
								'plugin' => 'ev_shop',
								'controller' => 'products'
							);
						}
						$return['action'] = 'index';
					}
				}

				$this->redirect($return);

			} else {

				// uh oh, fail.
				$this->Flash->fail(
					array(
						'title' => 'Save Failed',
						'description' => 'There was a problem saving the pricing'
					)
				);
			}

		} else {
			$this->request->data['Variants'] = $Model->manageListing($id);
		}

		$actionLabel = 'Manage';
		$this->set(
			array(
				'actionLabel' => $actionLabel,
				'title_for_layout' => $actionLabel . ' ' . InflectorExt::humanize($Model->displayName),
				'toolbar' => $this->_adminManageToolbar($id),
				'fields' => $this->_adminManageFields()
			)
		);

		$this->view = 'EvShop./Variants/admin_manage';
	}
}
