<?php
App::uses('EvShopAppController', 'EvShop.Controller');

class ProductsController extends EvShopAppController {

	/**
	 * redefine to allow the index / view page through the auth component!
	 */
	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array('index', 'view'));
	}

	/**
	 * product index page
	 * list all products out
	 *
	 */
	public function index() {
		$this->view = 'EvShop./Fallbacks/Products/index';
		$pageId = Configure::read('EvShop.pageIds.product');

		// check if we have a specific content page set
		// if so - set the template
		if (! empty($pageId)) {
			$pageData = $this->assignPage($pageId);

			if (! empty($pageData)) {
				$this->view = $this->Tpl->getTemplate($pageData, 'Page');
			}
		}

		$this->set(
			'listing',
			$this->Products->listing(array(), false)
		);

		$this->Breadcrumb->links(__('All Products'));
	}

	/**
	 * product view details page
	 *
	 * @param 	int 	Product ID
	 */
	public function view($id) {
		$this->view = 'EvShop./Fallbacks/Products/view';

		$data = $this->Product->readForView($id);
		if (empty($data)) {
			throw new NotFoundException();
		}

		$this->set('data', $data);
		$this->Meta->set($data);

		if (! empty($data)) {
			$this->view = $this->Tpl->getTemplate($data);
		}

		$this->_getProductBreadcrumb($data);
	}

	/**
	 * add the variant management link
	 * prices / stock control (if active)
	 */
	protected function _adminIndexActions() {
		if (in_array('EvShopVariants', App::objects('Controller'))) {
			$variantManageUrl = array(
				'plugin' => false,
				'controller' => 'ev_shop_variants',
				'action' => 'manage'
			);
		} else {
			$variantManageUrl = array(
				'plugin' => 'ev_shop',
				'controller' => 'variants',
				'action' => 'manage'
			);
		}

		$actions = array(
			'Pricing' => array(
				'cell' => array(
					'class' => 'action pricing'
				),
				'link' => array(
					'url' => $variantManageUrl,
					'text' => '<i class="fa fa-money"></i>',
					'options' => array(
						'escape' => false
					)
				)
			)
		) + parent::_adminIndexActions();

		return $actions;
	}

	/**
	 * form fields - check for EvTax and auto remove
	 * check for brands setting and auto remove
	 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['Product.description']['type'] = 'html';

		if (! CakePlugin::loaded('EvTax')) {
			unset($fields['Product.tax_level_id']);
		}

		if (! Configure::read('EvShop.showBrands')) {
			unset($fields['Product.brand_id']);
		}

		return $fields;
	}

	/**
	 * admin populate lookups
	 */
	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();

		if (Configure::read('EvShop.showBrands')) {
			$this->set(
				'brands',
				$this->Product->Brand->getForDropDown()
			);
		}
	}

	/**
	 * redefine admin edit to setup inject form
	 * for variants
	 */
	public function admin_edit($id = null) {
		$Model = $this->{$this->modelClass};

		$this->toInject('components', 'EvShop.Categories');
		$this->toInject('helpers', 'EvShop.Categories');

		if (Configure::read('EvShop.showVariants')) {
			$this->toInject('components', 'EvShop.Variants');
			$this->toInject('helpers', 'EvShop.Variants');
		}

		if ($this->Session->check('products.options')) {
			$this->request->data['CurrentOptions'] = $this->Session->read('products.options');
		}

		// calculate the redirect to allow pricing redirect if needed
		if ($id === null) {
			$nextId = $Model->find(
				'first',
				array(
					'fields' => 'id',
					'order' => $Model->alias . '.id DESC',
					'callbacks' => false
				)
			);
			$nextId = Hash::get($nextId, $Model->alias . '.id');

			if ($nextId > 0) {
				$nextId++;
			} else {
				$nextId = 1;
			}

			if (in_array('EvShopVariants', App::objects('Controller'))) {
				$this->adminRedirect = array(
					'plugin' => false,
					'controller' => 'ev_shop_variants',
				);
			} else {
				$this->adminRedirect = array(
					'plugin' => 'ev_shop',
					'controller' => 'variants'
				);
			}

			$this->adminRedirect['action'] = 'manage';
			$this->adminRedirect[] = $nextId;
		} else {

			if (! empty($this->request->data['pricing'])) {
				if (in_array('EvShopVariants', App::objects('Controller'))) {
					$this->adminRedirect = array(
						'plugin' => false,
						'controller' => 'ev_shop_variants',
					);
				} else {
					$this->adminRedirect = array(
						'plugin' => 'ev_shop',
						'controller' => 'variants'
					);
				}

				$this->adminRedirect['action'] = 'manage';
				$this->adminRedirect[] = $id;
			}
		}

		parent::admin_edit($id);

		if (! $this->request->is('post') && ! $this->request->is('put')) {
			$this->Session->write(
				'products.options',
				(! empty($this->request->data['Options'])) ? $this->request->data['Options'] : array()
			);
		}

		$this->view = 'EvShop./Products/admin_form';
	}
}
