<?php

App::uses('EvShopAppController', 'EvShop.Controller');

class GoogleFeedController extends EvShopAppController {

	public $components = array('RequestHandler');

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow('index');
	}

	/**
	 * main method for loading google feed
	 */
	public function index() {
		ini_set('memory_limit', '5000M');
		set_time_limit(0);

		$siteTitle = Configure::read('SiteSetting.general.site_title');

		// build the url
		$siteUrl = '';
		if (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443) {
			$siteUrl = 'https://';
		} else {
			$siteUrl = 'http://';
		}
		$siteUrl .= $_SERVER['HTTP_HOST'];

		$xml = new XMLWriter;
		$xml->openMemory();
		$xml->startDocument( '1.0', 'UTF-8');

		$xml->startElement( 'rss' );
			$xml->writeAttribute( 'version', '2.0' );
			$xml->writeAttribute( 'xmlns:g', 'http://base.google.com/ns/1.0' );

			$xml->startElement( 'channel' );
				$xml->writeElement( 'title', $siteTitle);
				$xml->writeElement( 'link', urlencode($siteUrl) );
				$xml->writeElement( 'description', $siteTitle . ' Product Feed' );

				// get the products
				$params = [
					'contain' => [
						'Brand',
						'CategoriesProduct' => [
							'order' => 'CategoriesProduct.sequence ASC',
							'Category'
						],
						'Variant.TaxLevel'
					]
				];
				if (CakePlugin::loaded('EvInventory')) {
					$params['contain']['Variant'][] = 'Inventory';
				}

				$ProductModel = EvClassRegistry::init('EvShop.Product');
				$VariantModel = EvClassRegistry::init('EvShop.Variant');
				$VariantModel->linkInventory();
				$VariantModel->linkTaxCalc();

				$products = $this->Products->listing($params, false);

				if (CakePlugin::loaded('EvTax')) {
					$TaxModel = EvClassRegistry::init('EvTax.TaxLevel');
					$taxLevels = array();
					$taxLevelData = $TaxModel->find('all');

					if (! empty($taxLevelData)) {
						foreach ($taxLevelData as $taxLevel) {
							$taxLevels[$taxLevel['TaxLevel']['id']] = $taxLevel['TaxLevel'];
						}
					}
				}

				foreach ($products as $product) {
					$variantCount = count($product['Variant']);

					$productUrl = $this->Routable->getItemRoute('EvShop', 'Product');
					$productUrl[] = $product['Product']['id'];

					$url = Router::url($productUrl);

					foreach ($product['Variant'] as $variant) {

						if ($variant['price'] <= 0 || empty($variant['sku']) || empty($product['Brand']['name'])) {
							continue;
						}
						$variant['TaxLevel'] = array();
						if (isset($taxLevels[$product['Product']['tax_level_id']])) {
							$variant['TaxLevel'] = $taxLevels[$product['Product']['tax_level_id']];
						}

						$variant = $VariantModel->calculateTax($variant, $this->Products);
						$xml->startElement('item');

							$xml->writeElement('g:id', $product['Product']['id'] . '_' . $variant['id']);

							$title = $product['Product']['name'];
							if ($variantCount > 1) {
								// if we have actual variants append the variant name
								$title .= ': ' . $variant['name'];
							}

							$title = preg_replace("/[^a-z0-9\s-_.,&+]/i", "", $title);
							$xml->writeElement('g:title', $title);

							$description = strip_tags($product['Product']['description']);
							$description = preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $description);
							$xml->startElement('g:description');
								$xml->writeCData($description);
							$xml->endElement();

							// @todo: categories
							$xml->writeElement( 'g:google_product_category', Configure::read('EvShop.googleFeedCategory'));

							// check for a category
							if (isset($product['CategoriesProduct']['0']['Category']['name']) && ! empty($product['CategoriesProduct']['0']['Category']['name'])) {
								$xml->writeElement('g:product_type', $product['CategoriesProduct']['0']['Category']['name']);
							}

							$xml->writeElement('g:link', $siteUrl . $url);

							// check for an image
							if (
								isset($product['ListingImage']['0']['filepath']) &&
								! empty($product['ListingImage']['0']['filepath']) &&
								file_exists(WWW_ROOT . $product['ListingImage']['0']['filepath'])
							) {

								$image = ltrim($product['ListingImage']['0']['filepath'], '/');
								$xml->writeElement('g:image_link', $siteUrl . '/' . $image);
							}

							$xml->writeElement('g:condition', 'new');

							if (CakePlugin::loaded('EvInventory')) {
								if ($variant['Inventory']['stock'] > 0) {
									$stock = 'in stock';
								} else {
									$stock = 'out of stock';
								}
							} else {
								$stock = 'in stock';
							}

							$xml->writeElement('g:availability', $stock);
							$xml->writeElement('g:price', number_format($variant['price_incTax'], 2) . ' GBP');
							$xml->writeElement('g:mpn', $variant['sku']);

							if ($variant['sale_price_incTax'] > 0) {
								$xml->writeElement('g:sale_price', number_format($variant['sale_price_incTax'], 2) . ' GBP');
							}

							if (! empty($product['Brand']['name'])) {
								$xml->writeElement('g:brand', $product['Brand']['name']);
							}

						$xml->endElement(); // </item>
					}
				}

			$xml->endElement(); // </channel>
		$xml->endElement(); // </rss>
		$xml->endDocument();

		$output = $xml->outputMemory();

		$this->response->disableCache();
		$this->response->length(strlen($output));
		$this->response->type('xml');
		$this->response->body($output);

		// output csv
		return $this->response;
	}

}
