<?php
App::uses('AppController', 'Controller');

class EvShopAppController extends AppController {

	/**
	 * Constructor
	 *
	 * @param ComponentCollection $collection A ComponentCollection this component can use to lazy load its components
	 * @param array $settings Array of configuration settings.
	 */
	public function __construct($request = null, $response = null) {
		$this->components[] = 'EvShop.Products';
		$this->components[] = 'EvShop.Categories';
		$this->components[] = 'EvShop.Brands';

		if (CakePlugin::loaded('EvBreadcrumb')) {
			$this->components[] = 'EvBreadcrumb.Breadcrumb';
		}

		if (CakePlugin::loaded('EvInventory')) {
			$this->helpers[] = 'EvInventory.Inventory';
		}

		$this->helpers[] = 'EvShop.Products';

		parent::__construct($request, $response);
	}

	/**
	 * given the current category, get the parents for breadcrumbs
	 *
	 * @param 	array 	$category 		The current category
	 * @param 	array 	$categories 	Array of all categories (optional)
	 * @param 	bool 	$isProductPath 	Product Category path, set so we can set the url on first category
	 * @return 	bool
	 */
	protected function _getCategoryParentsBreadcrumb($category, $categories = array(), $isProductPath = false) {
		if (! empty($category['Category']['parent_id'])) {
			$parentId = $category['Category']['parent_id'];

			if (! empty($categories)) {
				$catList = $categories;
			} else {
				$CategoryModel = EvClassRegistry::init('EvShop.Category');
				$catList = $CategoryModel->getBreadcrumbList();
			}

			if (isset($catList[$parentId])) {
				$this->_getCategoryParentsBreadcrumb(
					$catList[$parentId],
					$catList
				);
			}
		}

		$url = null;
		if ((! empty($categories) || $isProductPath === true) && ! empty($category['Category']['id'])) {
			$url = $this->Routable->getItemRoute('EvShop', 'Category');
			$url[] = $category['Category']['id'];
		}

		if (! empty($category['Category']['name'])) {
			$this->Breadcrumb->links(
				$category['Category']['name'],
				$url
			);
		}

		return true;
	}

	/**
	 * given the product array get the categories breadcrumb
	 *
	 * @param 	array 	$product 	The product array
	 * @return 	bool
	 */
	protected function _getProductBreadcrumb($product) {
		$category = array_shift($product['CategoriesProduct']);

		$this->_getCategoryParentsBreadcrumb($category, array(), true);

		$this->Breadcrumb->links(
			$product['Product']['name']
		);

		return true;
	}

}
