<?php

App::uses('AppComponent', 'Controller/Component');

class BrandsComponent extends AppComponent {

	/**
	 * get a brands listing
	 *
	 * @param 	array 	query / paginate params
	 * @param 	bool 	Paginate results or not?
	 * @return 	array 	Array of results
	 */
	public function listing($params = array(), $paginate = true) {
		$params = Hash::merge(
			array(
				'conditions' => array(
					'Brand.is_active' => 1
				),
				'order' => 'Brand.sequence ASC, Brand.name ASC',
				'contain' => array(
					'LogoImage'
				)
			),
			$params
		);

		$Brand = EvClassRegistry::init('EvShop.Brand');

		if ($paginate && ! empty($this->_controller)) {
			$this->_controller->Paginator->settings = $params;
			return $this->_controller->Paginator->paginate(
				$Brand
			);
		} else {
			return $Brand->find('all', $params);
		}
	}
}
