<?php

$config = array(
	'EvShop' => array(
		'showVariants' => true, // show variant/options to the admin during product management
		'showBrands' => true, // show brands in the admin during product management

		'pageIds' => array( // Page ids for brand, category, product index pages
			'brand' => null,
			'category' => null,
			'product' => null
		),

		/*
			If using the google product xml feed, use this to set the google product category
			https://support.google.com/merchants/answer/1705911
		*/
		'googleFeedCategory' => '',

		'route' => array(
			'Brand' => array(
				'controller' => 'ev_shop.brands',
				'action' => 'view',
				'plugin' => 'EvShop'
			),

			'Category' => array(
				'controller' => 'ev_shop.categories',
				'action' => 'view',
				'plugin' => 'EvShop'
			),

			'Product' => array(
				'controller' => 'ev_shop.products',
				'action' => 'view',
				'plugin' => 'EvShop'
			)
		)
	)
);
