<?php
class AddedTreeBehaviorToCategories extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'added_tree_behavior_to_categories';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'ev_shop_categories' => array(
					'lft' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'after' => 'parent_id'),
					'rght' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'after' => 'lft'),
				),
			),
			'drop_field' => array(
				'ev_shop_categories' => array('sequence'),
			),
		),
		'down' => array(
			'drop_field' => array(
				'ev_shop_categories' => array('lft', 'rght'),
			),
			'create_field' => array(
				'ev_shop_categories' => array(
					'sequence' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 5, 'unsigned' => false, 'comment' => 'ActsAs CustomFields - Would allow for body / descriptions to be added.'),
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
